/*
 * Decompiled with CFR 0.152.
 */
package ch.netcetera.eclipse.workspaceconfig.ui.handler;

import ch.netcetera.eclipse.workspaceconfig.ui.WorkspaceConfigurationUIPlugin;
import ch.netcetera.eclipse.workspaceconfig.ui.preferences.ConfigurationUtil;
import ch.netcetera.eclipse.workspaceconfig.ui.util.WorkspaceConfigurationStatusUtil;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.osgi.framework.FrameworkUtil;

public class WorkspaceStartupHandler
implements IStartup {
    protected static final int IMPORT_CONFIG = 0;
    protected static final int DO_NOT_IMPORT_CONFIG = 1;

    public void earlyStartup() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        final String bundleId = FrameworkUtil.getBundle(this.getClass()).getSymbolicName();
        boolean isNewWorkspace = WorkspaceConfigurationStatusUtil.isNewWorkspace();
        boolean checkEnabled = Platform.getPreferencesService().getBoolean(bundleId, "STARTUP_CHECK_V3", true, null);
        boolean urlConfigured = ConfigurationUtil.isEpfUrlConfigured();
        if (checkEnabled && isNewWorkspace && urlConfigured) {
            workbench.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                    if (window != null) {
                        String[] buttonLabels = new String[]{WorkspaceConfigurationUIPlugin.getDefault().getText("startup.handler.dialog.button.yes"), WorkspaceConfigurationUIPlugin.getDefault().getText("startup.handler.dialog.button.no"), WorkspaceConfigurationUIPlugin.getDefault().getText("startup.handler.dialog.button.ask.again")};
                        String message = WorkspaceConfigurationUIPlugin.getDefault().getText("startup.handler.dialog.text");
                        Image titleImage = WorkspaceConfigurationUIPlugin.getImageDescriptor("rsrc/dialog.gif").createImage();
                        String title = WorkspaceConfigurationUIPlugin.getDefault().getText("startup.handler.dialog.title");
                        MessageDialog dialog = new MessageDialog(window.getShell(), title, titleImage, message, 3, buttonLabels, 0);
                        int result = dialog.open();
                        if (result == 0) {
                            this.applySettings();
                            WorkspaceConfigurationStatusUtil.writeConfiguredFlag();
                        } else if (result == 1) {
                            WorkspaceConfigurationStatusUtil.writeNoConfigFlag();
                        }
                    }
                }

                private void applySettings() {
                    IHandlerService service = (IHandlerService)workbench.getService(IHandlerService.class);
                    try {
                        service.executeCommand("ch.netcetera.eclipse.workspaceconfig.ui.applySettings", null);
                    }
                    catch (CommandException e) {
                        ILog log = WorkspaceConfigurationUIPlugin.getDefault().getLog();
                        log.log((IStatus)new Status(4, bundleId, "applying settings failed", (Throwable)e));
                        WorkspaceStartupHandler.this.displayErrorDialog();
                    }
                }
            });
        }
    }

    private void displayErrorDialog() {
        WorkspaceConfigurationStatusUtil.writeErrorFlag();
        MessageBox errorDialog = new MessageBox(WorkspaceConfigurationUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), 1);
        errorDialog.setText(WorkspaceConfigurationUIPlugin.getDefault().getText("startup.handler.resultdialog.title.error"));
        errorDialog.setMessage(WorkspaceConfigurationUIPlugin.getDefault().getText("startup.handler.resultdialog.text.error"));
        errorDialog.open();
    }
}

