/*
 * Decompiled with CFR 0.152.
 */
package ch.netcetera.eclipse.workspaceconfig.ui.preferences;

import ch.netcetera.eclipse.workspaceconfig.ui.preferences.ConfigurationXMLMarshaler;
import ch.netcetera.eclipse.workspaceconfig.ui.preferences.ConfigurationXmlParser;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.framework.FrameworkUtil;

public final class ConfigurationUtil {
    private static String bundleSymbolicName = FrameworkUtil.getBundle(ConfigurationUtil.class).getSymbolicName();
    private static ConfigurationXMLMarshaler marshaler = new ConfigurationXMLMarshaler();
    private static ConfigurationXmlParser parser = new ConfigurationXmlParser();

    private ConfigurationUtil() {
        throw new AssertionError((Object)"Not instantiable.");
    }

    static void saveEpfUrls(Collection<String> epfUrls) {
        String xml = "";
        try {
            xml = marshaler.marshalEpfUrlList(epfUrls);
        }
        catch (IOException iOException) {}
        ConfigurationUtil.getPreferences().put("URL_V3", xml);
    }

    public static List<String> getEpfUrls() {
        String xml = Platform.getPreferencesService().getString(bundleSymbolicName, "URL_V3", "", null);
        try {
            return parser.parseEpfUrlList(xml);
        }
        catch (IOException iOException) {
            return Collections.emptyList();
        }
    }

    static void saveEnvReplacements(Collection<String> envReplacements) {
        String xml = "";
        try {
            xml = marshaler.marshalEnvVarList(envReplacements);
        }
        catch (IOException iOException) {}
        ConfigurationUtil.getPreferences().put("ENV_REPLACEMENT_LIST_V3", xml);
    }

    public static List<String> getEnvReplacements() {
        String xml = Platform.getPreferencesService().getString(bundleSymbolicName, "ENV_REPLACEMENT_LIST_V3", "", null);
        try {
            return parser.parseEnvVarList(xml);
        }
        catch (IOException iOException) {
            return Collections.emptyList();
        }
    }

    static void saveNewWorkspaceDetection(boolean newWorkspaceDetection) {
        ConfigurationUtil.getPreferences().putBoolean("STARTUP_CHECK_V3", newWorkspaceDetection);
    }

    public static boolean isEpfUrlConfigured() {
        return !ConfigurationUtil.getEpfUrls().isEmpty();
    }

    private static IEclipsePreferences getPreferences() {
        return DefaultScope.INSTANCE.getNode(FrameworkUtil.getBundle(ConfigurationUtil.class).getSymbolicName());
    }
}

