/*
 * Decompiled with CFR 0.152.
 */
package ch.netcetera.eclipse.workspaceconfig.ui.preferences;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class ConfigurationXmlParser {
    private static final String ENCODING = "ISO-8859-1";
    private final XMLInputFactory factory = XMLInputFactory.newInstance();

    ConfigurationXmlParser() {
        this.factory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        this.factory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.FALSE);
        this.factory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
        this.factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        this.factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
    }

    public List<String> parseEpfUrlList(String xml) throws IOException {
        return this.parseList("epfurls", "epfurl", xml);
    }

    public List<String> parseEnvVarList(String xml) throws IOException {
        return this.parseList("envvars", "envvar", xml);
    }

    private List<String> parseList(String rootElement, String listElement, String xml) throws IOException {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes(ENCODING));
            XMLStreamReader reader = this.factory.createXMLStreamReader(inputStream, ENCODING);
            ArrayList<String> envVarList = new ArrayList<String>();
            while (reader.hasNext()) {
                String localName;
                int event = reader.next();
                if (event != 1 || !rootElement.equals(localName = reader.getLocalName())) continue;
                while (reader.hasNext()) {
                    event = reader.next();
                    if (event != 1 || !listElement.equals(localName = reader.getLocalName())) continue;
                    envVarList.add(this.getContent(reader));
                }
            }
            return envVarList;
        }
        catch (XMLStreamException e) {
            throw new IOException("could not parse XML", e);
        }
    }

    private String getContent(XMLStreamReader reader) throws XMLStreamException {
        StringBuilder builder = new StringBuilder();
        while (reader.hasNext()) {
            int event = reader.next();
            if (event == 2) {
                return builder.toString().trim();
            }
            if (event != 4 && event != 12) continue;
            builder.append(reader.getText());
        }
        return builder.toString().trim();
    }
}

