/*
 * Decompiled with CFR 0.152.
 */
package ch.netcetera.eclipse.workspaceconfig.ui.preferences;

import ch.netcetera.eclipse.common.fieldeditor.AbstractEditableStringListFieldEditor;
import ch.netcetera.eclipse.common.text.ITextAccessor;
import ch.netcetera.eclipse.common.validator.UriInputValidator;
import ch.netcetera.eclipse.workspaceconfig.ui.preferences.ConfigurationUtil;
import ch.netcetera.eclipse.workspaceconfig.ui.preferences.ConfigurationXMLMarshaler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Composite;

public class EditableUrlStringListFieldEditor
extends AbstractEditableStringListFieldEditor {
    private ConfigurationXMLMarshaler marshaler = new ConfigurationXMLMarshaler();

    protected EditableUrlStringListFieldEditor(String name, String labelText, Composite parent, ITextAccessor textAccessor) {
        this(name, labelText, parent, textAccessor, false);
    }

    protected EditableUrlStringListFieldEditor(String name, String labelText, Composite parent, ITextAccessor textAccessor, boolean isReorderable) {
        super(name, labelText, parent, textAccessor, isReorderable);
    }

    public String getNewListItem() {
        InputDialog dialog = new InputDialog(this.getAddButtonShell(), this.getTextAccessor().getText("preference.dialog.url.title"), this.getTextAccessor().getText("preference.dialog.url.text"), null, (IInputValidator)new UriInputValidator(this.getListItems(), null, this.getTextAccessor()));
        if (dialog.open() == 0) {
            return dialog.getValue().trim();
        }
        return null;
    }

    public String editListItem(String item) {
        InputDialog dialog = new InputDialog(this.getEditButtonShell(), this.getTextAccessor().getText("preference.dialog.url.title"), this.getTextAccessor().getText("preference.dialog.url.text"), item, (IInputValidator)new UriInputValidator(this.getListItems(), item, this.getTextAccessor()));
        if (dialog.open() == 0) {
            return dialog.getValue().trim();
        }
        return item;
    }

    protected List<String> parsePreferenceString(String preferenceString) {
        return ConfigurationUtil.getEpfUrls();
    }

    protected String marshallPreferenceString(String[] items) {
        ArrayList<String> epfUrlList = new ArrayList<String>(items.length);
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            epfUrlList.add(string);
            ++n2;
        }
        try {
            return this.marshaler.marshalEpfUrlList(epfUrlList);
        }
        catch (IOException iOException) {
            return "";
        }
    }
}

