/*
 * Decompiled with CFR 0.152.
 */
package ch.netcetera.eclipse.common.dialog;

import ch.netcetera.eclipse.common.text.ITextAccessor;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LoginDialog
extends TitleAreaDialog
implements KeyListener {
    private final ITextAccessor textAccessor;
    private final String initName;
    private final String initPassword;
    private Text nameText;
    private Text passwordText;
    private String resultName;
    private String resultPassword;
    private boolean resultIsStorePassword;
    private Button storePasswordCheckBox;

    public LoginDialog(Shell parentShell, ITextAccessor textAccessor, String initName, String initPassword) {
        super(parentShell);
        this.textAccessor = textAccessor;
        this.initName = initName;
        this.initPassword = initPassword;
        this.setHelpAvailable(false);
        this.setBlockOnOpen(true);
    }

    public void create() {
        super.create();
        this.setTitle(this.textAccessor.getText("login.dialog.message.title"));
        this.setMessage(this.textAccessor.getText("login.dialog.message.text"));
        this.keyPressed(null);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.textAccessor.getText("login.dialog.title"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 15;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        Label nameLabel = new Label(composite, 16384);
        nameLabel.setText(this.textAccessor.getText("login.dialog.username"));
        this.nameText = new Text(composite, 2048);
        GridData nameTextGridData = new GridData(16384, 128, true, false);
        nameTextGridData.minimumWidth = 300;
        this.nameText.setLayoutData((Object)nameTextGridData);
        this.nameText.addKeyListener((KeyListener)this);
        this.nameText.setText(this.initName);
        Label passwordLabel = new Label(composite, 16384);
        passwordLabel.setText(this.textAccessor.getText("login.dialog.password"));
        this.passwordText = new Text(composite, 0x400800);
        GridData passwordTextGridData = new GridData(16384, 128, true, false);
        passwordTextGridData.minimumWidth = 300;
        this.passwordText.setLayoutData((Object)passwordTextGridData);
        this.passwordText.addKeyListener((KeyListener)this);
        this.passwordText.setText(this.initPassword);
        this.storePasswordCheckBox = new Button(composite, 32);
        this.storePasswordCheckBox.setText(this.textAccessor.getText("login.dialog.storepassword"));
        return composite;
    }

    public void keyPressed(KeyEvent e) {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(this.nameText.getText().trim().length() > 0 && this.passwordText.getText().trim().length() > 0);
        }
    }

    public void keyReleased(KeyEvent e) {
        this.keyPressed(e);
    }

    public String getUsername() {
        return this.resultName;
    }

    public String getPassword() {
        return this.resultPassword;
    }

    public boolean isStorePassword() {
        return this.resultIsStorePassword;
    }

    protected void okPressed() {
        this.resultName = this.nameText.getText();
        this.resultPassword = this.passwordText.getText();
        this.resultIsStorePassword = this.storePasswordCheckBox.getSelection();
        super.okPressed();
    }
}

