/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.scriptengine.java;

import ch.obermuhlner.scriptengine.java.JavaScriptEngine;
import ch.obermuhlner.scriptengine.java.execution.ExecutionStrategy;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

public class JavaCompiledScript
extends CompiledScript {
    private final JavaScriptEngine engine;
    private final Class<?> instanceClass;
    private final Object instance;
    private ExecutionStrategy executionStrategy;

    JavaCompiledScript(JavaScriptEngine engine, Class<?> instanceClass, Object instance, ExecutionStrategy executionStrategy) {
        this.engine = engine;
        this.instanceClass = instanceClass;
        this.instance = instance;
        this.executionStrategy = executionStrategy;
    }

    public Class<?> getInstanceClass() {
        return this.instanceClass;
    }

    public Object getInstance() {
        return this.instance;
    }

    public void setExecutionStrategy(ExecutionStrategy executionStrategy) {
        this.executionStrategy = executionStrategy;
    }

    @Override
    public ScriptEngine getEngine() {
        return this.engine;
    }

    @Override
    public Object eval(ScriptContext context) throws ScriptException {
        Bindings globalBindings = context.getBindings(200);
        Bindings engineBindings = context.getBindings(100);
        this.pushVariables(globalBindings, engineBindings);
        Object result = this.executionStrategy.execute(this.instance);
        this.pullVariables(globalBindings, engineBindings);
        return result;
    }

    private void pushVariables(Bindings globalBindings, Bindings engineBindings) throws ScriptException {
        Map<String, Object> mergedBindings = this.mergeBindings(globalBindings, engineBindings);
        for (Map.Entry<String, Object> entry : mergedBindings.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            try {
                Field field = this.instanceClass.getField(name);
                field.set(this.instance, value);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new ScriptException(e);
            }
        }
    }

    private void pullVariables(Bindings globalBindings, Bindings engineBindings) throws ScriptException {
        for (Field field : this.instanceClass.getFields()) {
            try {
                String name = field.getName();
                Object value = field.get(this.instance);
                this.setBindingsValue(globalBindings, engineBindings, name, value);
            }
            catch (IllegalAccessException e) {
                throw new ScriptException(e);
            }
        }
    }

    private void setBindingsValue(Bindings globalBindings, Bindings engineBindings, String name, Object value) {
        if (!engineBindings.containsKey(name) && globalBindings.containsKey(name)) {
            globalBindings.put(name, value);
        } else {
            engineBindings.put(name, value);
        }
    }

    private Map<String, Object> mergeBindings(Bindings ... bindingsToMerge) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        for (Bindings bindings : bindingsToMerge) {
            if (bindings == null) continue;
            for (Map.Entry globalEntry : bindings.entrySet()) {
                variables.put((String)globalEntry.getKey(), globalEntry.getValue());
            }
        }
        return variables;
    }
}

