/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.scriptengine.java;

import java.util.Map;

public class MemoryClassLoader
extends ClassLoader {
    private Map<String, byte[]> mapClassBytes;

    public MemoryClassLoader(Map<String, byte[]> mapClassBytes, ClassLoader parent) {
        super(parent);
        this.mapClassBytes = mapClassBytes;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        byte[] bytes = this.mapClassBytes.get(name);
        if (bytes == null) {
            return super.loadClass(name);
        }
        return this.defineClass(name, bytes, 0, bytes.length);
    }
}

