/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.scriptengine.java.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static boolean matchesArguments(Constructor<?> constructor, Object[] arguments) {
        return ReflectionUtil.matchesArguments(constructor.getParameterTypes(), arguments);
    }

    public static boolean matchesArguments(Method method, Object[] arguments) {
        return ReflectionUtil.matchesArguments(method.getParameterTypes(), arguments);
    }

    public static boolean matchesArguments(Class<?>[] argumentTypes, Object[] arguments) {
        if (arguments.length != argumentTypes.length) {
            return false;
        }
        for (int i = 0; i < arguments.length; ++i) {
            if (!(arguments[i] == null ? argumentTypes[i].isPrimitive() : !ReflectionUtil.matchesType(argumentTypes[i], arguments[i].getClass()))) continue;
            return false;
        }
        return true;
    }

    public static boolean matchesType(Class<?> parameterType, Class<?> argumentType) {
        if (parameterType == Integer.TYPE && argumentType == Integer.class || parameterType == Long.TYPE && argumentType == Long.class || parameterType == Short.TYPE && argumentType == Short.class || parameterType == Byte.TYPE && argumentType == Byte.class || parameterType == Boolean.TYPE && argumentType == Boolean.class || parameterType == Float.TYPE && argumentType == Float.class || parameterType == Double.TYPE && argumentType == Double.class || parameterType == Character.TYPE && argumentType == Character.class) {
            return true;
        }
        return parameterType.isAssignableFrom(argumentType);
    }
}

