/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.scriptengine.jshell;

import ch.obermuhlner.scriptengine.jshell.JShellScriptEngineFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import jdk.jshell.DeclarationSnippet;
import jdk.jshell.Diag;
import jdk.jshell.EvalException;
import jdk.jshell.JShell;
import jdk.jshell.JShellException;
import jdk.jshell.Snippet;
import jdk.jshell.SnippetEvent;
import jdk.jshell.SourceCodeAnalysis;
import jdk.jshell.execution.DirectExecutionControl;
import jdk.jshell.spi.ExecutionControl;
import jdk.jshell.spi.ExecutionControlProvider;
import jdk.jshell.spi.ExecutionEnv;

public class JShellScriptEngine
implements ScriptEngine {
    private ScriptContext context = new SimpleScriptContext();
    private final AccessDirectExecutionControl accessDirectExecutionControl = new AccessDirectExecutionControl();
    private final JShell jshell = JShell.builder().executionEngine(new AccessDirectExecutionControlProvider(this.accessDirectExecutionControl), null).build();
    private static Map<String, Object> staticVariables;

    @Override
    public ScriptContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(ScriptContext context) {
        Objects.requireNonNull(context);
        this.context = context;
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public Bindings getBindings(int scope) {
        return this.context.getBindings(scope);
    }

    @Override
    public void setBindings(Bindings bindings, int scope) {
        this.context.setBindings(bindings, scope);
    }

    @Override
    public void put(String key, Object value) {
        this.getBindings(100).put(key, value);
    }

    @Override
    public Object get(String key) {
        return this.getBindings(100).get(key);
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return new JShellScriptEngineFactory();
    }

    @Override
    public Object eval(Reader reader) throws ScriptException {
        return this.eval(this.readScript(reader));
    }

    @Override
    public Object eval(String script) throws ScriptException {
        return this.eval(script, this.context);
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        return this.eval(this.readScript(reader), context);
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        return this.eval(script, context.getBindings(100));
    }

    @Override
    public Object eval(Reader reader, Bindings bindings) throws ScriptException {
        return this.eval(this.readScript(reader), bindings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object eval(String script, Bindings bindings) throws ScriptException {
        JShell jShell = this.jshell;
        synchronized (jShell) {
            Bindings globalBindings = this.context.getBindings(200);
            this.pushVariables(globalBindings, bindings);
            Object result = this.evaluateScript(script);
            this.pullVariables(globalBindings, bindings);
            return result;
        }
    }

    private void pushVariables(Bindings globalBindings, Bindings engineBindings) throws ScriptException {
        staticVariables = this.mergeBindings(globalBindings, engineBindings);
        HashSet<String> remainingKeys = new HashSet<String>(staticVariables.keySet());
        try {
            this.jshell.variables().forEach(varSnippet -> {
                String name = varSnippet.name();
                remainingKeys.remove(name);
                try {
                    Object value = JShellScriptEngine.getVariableValue(name);
                    String type = this.determineType(value);
                    String script = name + " = (" + type + ") " + this.getClass().getName() + ".getVariableValue(\"" + name + "\");";
                    this.evaluateScript(script);
                }
                catch (ScriptException e) {
                    throw new ScriptRuntimeException(e);
                }
            });
        }
        catch (ScriptRuntimeException e) {
            throw (ScriptException)e.getCause();
        }
        for (String name : remainingKeys) {
            Object value = JShellScriptEngine.getVariableValue(name);
            String type = this.determineType(value);
            String script = "var " + name + " = (" + type + ") " + this.getClass().getName() + ".getVariableValue(\"" + name + "\");";
            this.evaluateScript(script);
        }
    }

    private void pullVariables(Bindings globalBindings, Bindings engineBindings) throws ScriptException {
        try {
            this.jshell.variables().forEach(varSnippet -> {
                String name = varSnippet.name();
                String script = this.getClass().getName() + ".setVariableValue(\"" + name + "\", " + name + ");";
                try {
                    this.evaluateScript(script);
                    Object value = JShellScriptEngine.getVariableValue(name);
                    this.setBindingsValue(globalBindings, engineBindings, name, value);
                }
                catch (ScriptException e) {
                    throw new ScriptRuntimeException(e);
                }
            });
        }
        catch (ScriptRuntimeException e) {
            throw (ScriptException)e.getCause();
        }
    }

    private void setBindingsValue(Bindings globalBindings, Bindings engineBindings, String name, Object value) {
        if (!engineBindings.containsKey(name) && globalBindings.containsKey(name)) {
            globalBindings.put(name, value);
        } else {
            engineBindings.put(name, value);
        }
    }

    private String determineType(Object value) {
        if (value == null) {
            return Object.class.getCanonicalName();
        }
        for (Class<?> clazz = value.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            if (this.isValidType(clazz)) {
                return clazz.getCanonicalName();
            }
            for (Class<?> interfaceClazz : clazz.getInterfaces()) {
                if (!this.isValidType(interfaceClazz)) continue;
                return interfaceClazz.getCanonicalName();
            }
        }
        return Object.class.getCanonicalName();
    }

    private boolean isValidType(Class<?> clazz) {
        if (clazz.getCanonicalName() == null) {
            return false;
        }
        return (clazz.getModifiers() & 6) == 0;
    }

    public static Object getVariableValue(String name) {
        return staticVariables.get(name);
    }

    public static void setVariableValue(String name, Object value) {
        staticVariables.put(name, value);
    }

    private Object evaluateScript(String script) throws ScriptException {
        Object result = null;
        while (!script.isEmpty()) {
            SourceCodeAnalysis.CompletionInfo completionInfo = this.jshell.sourceCodeAnalysis().analyzeCompletion(script);
            if (!completionInfo.completeness().isComplete()) {
                throw new ScriptException("Incomplete script\n" + script);
            }
            List<SnippetEvent> events = this.jshell.eval(completionInfo.source());
            for (SnippetEvent event : events) {
                DeclarationSnippet declarationSnippet;
                List unresolvedDependencies;
                if (event.exception() != null) {
                    String message;
                    JShellException exception = event.exception();
                    String string = message = exception.getMessage() == null ? "" : ": " + exception.getMessage();
                    if (exception instanceof EvalException) {
                        EvalException evalException = (EvalException)exception;
                        throw new ScriptException(evalException.getExceptionClassName() + message + "\n" + event.snippet().source());
                    }
                    throw new ScriptException(message + "\n" + event.snippet().source());
                }
                if (event.status() == Snippet.Status.VALID) {
                    result = this.accessDirectExecutionControl.getLastValue();
                    continue;
                }
                Snippet snippet = event.snippet();
                Optional<Diag> optionalDiag = this.jshell.diagnostics(snippet).findAny();
                if (optionalDiag.isPresent()) {
                    Diag diag = optionalDiag.get();
                    throw new ScriptException(diag.getMessage(null) + "\n" + completionInfo.source());
                }
                if (snippet instanceof DeclarationSnippet && !(unresolvedDependencies = this.jshell.unresolvedDependencies(declarationSnippet = (DeclarationSnippet)snippet).collect(Collectors.toList())).isEmpty()) {
                    throw new ScriptException("Unresolved dependencies: " + unresolvedDependencies + "\n" + completionInfo.source());
                }
                throw new ScriptException("Unknown error\n" + completionInfo.source());
            }
            script = completionInfo.remaining();
        }
        return result;
    }

    private Map<String, Object> mergeBindings(Bindings ... bindingsToMerge) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        for (Bindings bindings : bindingsToMerge) {
            if (bindings == null) continue;
            for (Map.Entry globalEntry : bindings.entrySet()) {
                variables.put((String)globalEntry.getKey(), globalEntry.getValue());
            }
        }
        return variables;
    }

    private String readScript(Reader reader) throws ScriptException {
        try {
            String line;
            StringBuilder s = new StringBuilder();
            BufferedReader bufferedReader = new BufferedReader(reader);
            while ((line = bufferedReader.readLine()) != null) {
                s.append(line);
                s.append("\n");
            }
            return s.toString();
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    private static class AccessDirectExecutionControlProvider
    implements ExecutionControlProvider {
        private AccessDirectExecutionControl accessDirectExecutionControl;

        AccessDirectExecutionControlProvider(AccessDirectExecutionControl accessDirectExecutionControl) {
            this.accessDirectExecutionControl = accessDirectExecutionControl;
        }

        @Override
        public String name() {
            return "accessdirect";
        }

        @Override
        public ExecutionControl generate(ExecutionEnv env, Map<String, String> parameters) throws Throwable {
            return this.accessDirectExecutionControl;
        }
    }

    private static class AccessDirectExecutionControl
    extends DirectExecutionControl {
        private Object lastValue;

        private AccessDirectExecutionControl() {
        }

        @Override
        protected String invoke(Method doitMethod) throws Exception {
            this.lastValue = doitMethod.invoke(null, new Object[0]);
            return AccessDirectExecutionControl.valueString(this.lastValue);
        }

        public Object getLastValue() {
            return this.lastValue;
        }
    }

    private static class ScriptRuntimeException
    extends RuntimeException {
        public ScriptRuntimeException(ScriptException cause) {
            super(cause);
        }
    }
}

