/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.scriptengine.jshell;

import ch.obermuhlner.scriptengine.jshell.JShellScriptEngine;
import ch.obermuhlner.scriptengine.jshell.VariablesTransfer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import jdk.jshell.DeclarationSnippet;
import jdk.jshell.Diag;
import jdk.jshell.EvalException;
import jdk.jshell.JShell;
import jdk.jshell.JShellException;
import jdk.jshell.Snippet;
import jdk.jshell.SnippetEvent;
import jdk.jshell.SourceCodeAnalysis;
import jdk.jshell.execution.DirectExecutionControl;
import jdk.jshell.execution.LocalExecutionControlProvider;
import jdk.jshell.spi.ExecutionControl;
import jdk.jshell.spi.ExecutionControlProvider;
import jdk.jshell.spi.ExecutionEnv;

public class JShellCompiledScript
extends CompiledScript {
    private final JShellScriptEngine engine;
    private final List<String> snippets;

    JShellCompiledScript(JShellScriptEngine engine, String script) throws ScriptException {
        this.engine = engine;
        try (JShell jshell = JShell.builder().executionEngine(new LocalExecutionControlProvider(), null).build();){
            this.snippets = JShellCompiledScript.compileScript(jshell, script);
        }
    }

    @Override
    public Object eval(ScriptContext context) throws ScriptException {
        Bindings globalBindings = context.getBindings(200);
        Bindings engineBindings = context.getBindings(100);
        AccessDirectExecutionControl accessDirectExecutionControl = new AccessDirectExecutionControl();
        try (JShell jshell = JShell.builder().executionEngine(new AccessDirectExecutionControlProvider(accessDirectExecutionControl), null).build();){
            this.pushVariables(jshell, accessDirectExecutionControl, globalBindings, engineBindings);
            Object result = this.evaluateSnippets(jshell, accessDirectExecutionControl);
            this.pullVariables(jshell, accessDirectExecutionControl, globalBindings, engineBindings);
            Object object = result;
            return object;
        }
    }

    private void pushVariables(JShell jshell, AccessDirectExecutionControl accessDirectExecutionControl, Bindings globalBindings, Bindings engineBindings) throws ScriptException {
        Map<String, Object> variables = this.mergeBindings(globalBindings, engineBindings);
        VariablesTransfer.setVariables(variables);
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            String type = this.determineType(value);
            String script = type + " " + name + " = (" + type + ") " + VariablesTransfer.class.getName() + ".getVariableValue(\"" + name + "\");";
            this.evaluateSnippet(jshell, accessDirectExecutionControl, script);
        }
    }

    private void pullVariables(JShell jshell, AccessDirectExecutionControl accessDirectExecutionControl, Bindings globalBindings, Bindings engineBindings) throws ScriptException {
        try {
            jshell.variables().forEach(varSnippet -> {
                String name = varSnippet.name();
                String script = VariablesTransfer.class.getName() + ".setVariableValue(\"" + name + "\", " + name + ");";
                try {
                    this.evaluateSnippet(jshell, accessDirectExecutionControl, script);
                    Object value = VariablesTransfer.getVariableValue(name);
                    this.setBindingsValue(globalBindings, engineBindings, name, value);
                }
                catch (ScriptException e) {
                    throw new ScriptRuntimeException(e);
                }
            });
        }
        catch (ScriptRuntimeException e) {
            throw (ScriptException)e.getCause();
        }
        VariablesTransfer.clear();
    }

    private void setBindingsValue(Bindings globalBindings, Bindings engineBindings, String name, Object value) {
        if (!engineBindings.containsKey(name) && globalBindings.containsKey(name)) {
            globalBindings.put(name, value);
        } else {
            engineBindings.put(name, value);
        }
    }

    private String determineType(Object value) {
        if (value == null) {
            return Object.class.getCanonicalName();
        }
        for (Class<?> clazz = value.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            if (this.isValidType(clazz)) {
                return clazz.getCanonicalName();
            }
            for (Class<?> interfaceClazz : clazz.getInterfaces()) {
                if (!this.isValidType(interfaceClazz)) continue;
                return interfaceClazz.getCanonicalName();
            }
        }
        return Object.class.getCanonicalName();
    }

    private boolean isValidType(Class<?> clazz) {
        if (clazz.getCanonicalName() == null) {
            return false;
        }
        return (clazz.getModifiers() & 6) == 0;
    }

    private Map<String, Object> mergeBindings(Bindings ... bindingsToMerge) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        for (Bindings bindings : bindingsToMerge) {
            if (bindings == null) continue;
            for (Map.Entry globalEntry : bindings.entrySet()) {
                variables.put((String)globalEntry.getKey(), globalEntry.getValue());
            }
        }
        return variables;
    }

    private Object evaluateSnippets(JShell jshell, AccessDirectExecutionControl accessDirectExecutionControl) throws ScriptException {
        Object result = null;
        for (String snippetScript : this.snippets) {
            result = this.evaluateSnippet(jshell, accessDirectExecutionControl, snippetScript);
        }
        return result;
    }

    private Object evaluateSnippet(JShell jshell, AccessDirectExecutionControl accessDirectExecutionControl, String snippetScript) throws ScriptException {
        Object result = null;
        List<SnippetEvent> events = jshell.eval(snippetScript);
        for (SnippetEvent event : events) {
            if (event.status() == Snippet.Status.VALID && event.exception() == null) {
                result = accessDirectExecutionControl.getLastValue();
                continue;
            }
            this.throwAsScriptException(jshell, event);
        }
        return result;
    }

    private void throwAsScriptException(JShell jshell, SnippetEvent event) throws ScriptException {
        DeclarationSnippet declarationSnippet;
        List unresolvedDependencies;
        if (event.exception() != null) {
            String message;
            JShellException exception = event.exception();
            String string = message = exception.getMessage() == null ? "" : ": " + exception.getMessage();
            if (exception instanceof EvalException) {
                EvalException evalException = (EvalException)exception;
                throw new ScriptException(evalException.getExceptionClassName() + message + "\n" + event.snippet().source());
            }
            throw new ScriptException(message + "\n" + event.snippet().source());
        }
        Snippet snippet = event.snippet();
        Optional<Diag> optionalDiag = jshell.diagnostics(snippet).findAny();
        if (optionalDiag.isPresent()) {
            Diag diag = optionalDiag.get();
            throw new ScriptException(diag.getMessage(null) + "\n" + snippet);
        }
        if (snippet instanceof DeclarationSnippet && !(unresolvedDependencies = jshell.unresolvedDependencies(declarationSnippet = (DeclarationSnippet)snippet).collect(Collectors.toList())).isEmpty()) {
            throw new ScriptException("Unresolved dependencies: " + unresolvedDependencies + "\n" + snippet);
        }
        throw new ScriptException("Unknown error\n" + snippet);
    }

    @Override
    public ScriptEngine getEngine() {
        return this.engine;
    }

    private static List<String> compileScript(JShell jshell, String script) throws ScriptException {
        ArrayList<String> snippets = new ArrayList<String>();
        while (!script.isEmpty()) {
            SourceCodeAnalysis.CompletionInfo completionInfo = jshell.sourceCodeAnalysis().analyzeCompletion(script);
            if (!completionInfo.completeness().isComplete()) {
                throw new ScriptException("Incomplete script\n" + script);
            }
            snippets.add(completionInfo.source());
            script = completionInfo.remaining();
        }
        return snippets;
    }

    private static class AccessDirectExecutionControlProvider
    implements ExecutionControlProvider {
        private AccessDirectExecutionControl accessDirectExecutionControl;

        AccessDirectExecutionControlProvider(AccessDirectExecutionControl accessDirectExecutionControl) {
            this.accessDirectExecutionControl = accessDirectExecutionControl;
        }

        @Override
        public String name() {
            return "accessdirect";
        }

        @Override
        public ExecutionControl generate(ExecutionEnv env, Map<String, String> parameters) throws Throwable {
            return this.accessDirectExecutionControl;
        }
    }

    private static class AccessDirectExecutionControl
    extends DirectExecutionControl {
        private Object lastValue;

        private AccessDirectExecutionControl() {
        }

        @Override
        protected String invoke(Method doitMethod) throws Exception {
            this.lastValue = doitMethod.invoke(null, new Object[0]);
            return AccessDirectExecutionControl.valueString(this.lastValue);
        }

        public Object getLastValue() {
            return this.lastValue;
        }
    }

    private static class ScriptRuntimeException
    extends RuntimeException {
        public ScriptRuntimeException(ScriptException cause) {
            super(cause);
        }
    }
}

