/*
 * Decompiled with CFR 0.152.
 */
package ch.oliumbi.compass.core.enums;

import ch.oliumbi.compass.core.enums.Translatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum MimeType implements Translatable<String>
{
    PLAIN,
    HTML,
    CSS,
    JAVASCRIPT,
    JSON,
    XML,
    MULTI_PART,
    PDF,
    PNG,
    JPEG,
    SVG,
    ICON,
    WOFF2,
    TTF,
    OTF;

    public static final Logger LOGGER;

    @Override
    public String translate() {
        switch (this.ordinal()) {
            case 0: {
                return "text/plain";
            }
            case 1: {
                return "text/html";
            }
            case 2: {
                return "text/css";
            }
            case 3: {
                return "text/javascript";
            }
            case 4: {
                return "application/json";
            }
            case 6: {
                return "multipart/form-data";
            }
            case 5: {
                return "application/xml";
            }
            case 7: {
                return "application/pdf";
            }
            case 8: {
                return "image/png";
            }
            case 9: {
                return "image/jpeg";
            }
            case 10: {
                return "image/svg+xml";
            }
            case 11: {
                return "image/vnd.microsoft.icon";
            }
            case 12: {
                return "font/woff2";
            }
            case 13: {
                return "font/ttf";
            }
            case 14: {
                return "font/otf";
            }
        }
        LOGGER.error("Unexpected value: " + String.valueOf(this));
        return "text/plain";
    }

    public String extension() {
        switch (this.ordinal()) {
            case 1: {
                return ".html";
            }
            case 2: {
                return ".css";
            }
            case 3: {
                return ".js";
            }
            case 4: {
                return ".json";
            }
            case 5: {
                return ".xml";
            }
            case 7: {
                return ".pdf";
            }
            case 8: {
                return ".png";
            }
            case 9: {
                return ".jpg";
            }
            case 10: {
                return ".svg";
            }
            case 11: {
                return ".ico";
            }
            case 12: {
                return ".woff2";
            }
            case 13: {
                return ".ttf";
            }
            case 14: {
                return ".otf";
            }
        }
        return "";
    }

    static {
        LOGGER = LoggerFactory.getLogger(MimeType.class);
    }
}

