/*
 * Decompiled with CFR 0.152.
 */
package ch.oliumbi.compass.core.autoload;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

public class AutoloadInstantiate {
    private final List<Object> instances = new ArrayList<Object>();

    public Object instantiate(Class<?> clazz) {
        for (Object instance : this.instances) {
            if (!clazz.isInstance(instance)) continue;
            return instance;
        }
        Constructor<?> constructor = this.getConstructor(clazz);
        ArrayList<Object> constructorArguments = new ArrayList<Object>();
        for (Class<?> parameterType : constructor.getParameterTypes()) {
            if (this.isCircular(clazz, parameterType)) {
                throw new RuntimeException(clazz.getName() + ", has circular dependency from parameter: " + parameterType.getName());
            }
            constructorArguments.add(this.instantiate(parameterType));
        }
        try {
            Object instance = constructor.newInstance(constructorArguments.toArray());
            this.instances.add(instance);
            return instance;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(clazz.getName() + ", is an abstract class", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(clazz.getName() + ", constructor is inaccessible", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(clazz.getName() + ", constructor threw an exception", e);
        }
    }

    private Constructor<?> getConstructor(Class<?> clazz) {
        Constructor<?>[] constructors = clazz.getConstructors();
        if (constructors.length == 0) {
            throw new RuntimeException(clazz.getName() + ", has no public constructors, or if the class is an array class, or if the class reflects a primitive type or void");
        }
        if (constructors.length > 1) {
            throw new RuntimeException(clazz.getName() + ", has multiple constructors");
        }
        return constructors[0];
    }

    private boolean isCircular(Class<?> clazz, Class<?> parameter) {
        if (clazz.equals(parameter)) {
            return true;
        }
        for (Class<?> parameterType : this.getConstructor(parameter).getParameterTypes()) {
            boolean circular = this.isCircular(clazz, parameterType);
            if (!circular) continue;
            return true;
        }
        return false;
    }
}

