/*
 * Decompiled with CFR 0.152.
 */
package ch.oliumbi.compass.core.autoload;

import ch.oliumbi.compass.core.autoload.AutoloadPackage;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoloadPackageFile
extends AutoloadPackage {
    public static final Logger LOGGER = LoggerFactory.getLogger(AutoloadPackageFile.class);

    @Override
    public String protocol() {
        return "file";
    }

    @Override
    public List<Class<?>> classes(ClassLoader classLoader, URL url, String packageName) {
        ArrayList classes = new ArrayList();
        try {
            List<String> paths = Files.walk(Paths.get(url.toURI()), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(path -> path.toUri().getPath()).toList();
            for (String path2 : paths) {
                String className = path2.replace(url.getPath(), "").replace(".class", "").replace("/", ".");
                classes.add(classLoader.loadClass(packageName + className));
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to load class, url " + String.valueOf(url), (Throwable)e);
        }
        return classes;
    }
}

