/*
 * Decompiled with CFR 0.152.
 */
package ch.oliumbi.compass.server;

import ch.oliumbi.compass.core.enums.Method;
import ch.oliumbi.compass.server.Service;
import ch.oliumbi.compass.server.cookie.Cookie;
import ch.oliumbi.compass.server.header.Header;
import ch.oliumbi.compass.server.param.Param;
import ch.oliumbi.compass.server.path.Path;
import ch.oliumbi.compass.server.request.Request;
import ch.oliumbi.compass.server.response.Response;
import java.nio.ByteBuffer;
import java.util.List;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;

public class Entrypoint
extends Handler.Abstract {
    private final Service service = new Service();

    public boolean handle(org.eclipse.jetty.server.Request jettyRequest, org.eclipse.jetty.server.Response jettyResponse, Callback callback) {
        String url = jettyRequest.getHttpURI().getDecodedPath();
        String params = jettyRequest.getHttpURI().getQuery();
        String method = jettyRequest.getMethod();
        HttpFields headers = jettyRequest.getHeaders();
        String body = BufferUtil.toString((ByteBuffer)jettyRequest.read().getByteBuffer());
        List cookies = org.eclipse.jetty.server.Request.getCookies((org.eclipse.jetty.server.Request)jettyRequest);
        Request compassRequest = new Request();
        compassRequest.setPath(Path.create(url));
        compassRequest.setParams(Param.create(params));
        compassRequest.setMethod(Method.create((String)method));
        compassRequest.setHeaders(Header.create(headers));
        compassRequest.setBody(body);
        compassRequest.setCookies(Cookie.create(cookies));
        Response compassResponse = this.service.handle(compassRequest);
        jettyResponse.setStatus(compassResponse.getStatus().translate().intValue());
        jettyResponse.getHeaders().add(new HttpField("Content-Type", compassResponse.getType().translate()));
        for (Header header : compassResponse.getHeaders()) {
            jettyResponse.getHeaders().add(header.convert());
        }
        for (Cookie cookie : compassResponse.getCookies()) {
            org.eclipse.jetty.server.Response.addCookie((org.eclipse.jetty.server.Response)jettyResponse, (HttpCookie)cookie.build());
        }
        jettyResponse.write(true, BufferUtil.toBuffer((byte[])compassResponse.getBody()), callback);
        return true;
    }
}

