/*
 * Decompiled with CFR 0.152.
 */
package ch.oliumbi.compass.server.cookie;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.http.HttpCookie;

public class Cookie {
    private String name;
    private String value;
    private long maxAge;

    public static List<Cookie> create(List<HttpCookie> httpCookies) {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        for (HttpCookie httpCookie : httpCookies) {
            cookies.add(new Cookie(httpCookie.getName(), httpCookie.getValue(), httpCookie.getMaxAge()));
        }
        return cookies;
    }

    public HttpCookie build() {
        return HttpCookie.build((String)this.name, (String)this.value).path("/").sameSite(HttpCookie.SameSite.STRICT).secure(true).maxAge(this.maxAge).build();
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setMaxAge(long maxAge) {
        this.maxAge = maxAge;
    }

    public Cookie(String name, String value, long maxAge) {
        this.name = name;
        this.value = value;
        this.maxAge = maxAge;
    }

    public Cookie() {
    }
}

