/*
 * Decompiled with CFR 0.152.
 */
package ch.oliumbi.compass.server.path;

public class Path {
    private String url;
    private String pattern;

    public static Path create(String url) {
        Path path = new Path();
        path.setUrl(url);
        return path;
    }

    public boolean matches() {
        int urlPointer;
        String[] patterns = this.pattern.split("/");
        String[] urls = this.url.split("/");
        int patternPointer = 0;
        for (urlPointer = 0; patternPointer < patterns.length && urlPointer < urls.length; ++patternPointer, ++urlPointer) {
            String pattern = patterns[patternPointer];
            String url = urls[urlPointer];
            if ("**".equals(pattern)) {
                return true;
            }
            if (this.match(pattern, url)) continue;
            return false;
        }
        if (patternPointer != patterns.length) {
            return false;
        }
        return urlPointer == urls.length;
    }

    private boolean match(String pattern, String url) {
        if (pattern.equals("*") && !url.isBlank()) {
            return true;
        }
        if (pattern.startsWith(":") && !url.isBlank()) {
            return true;
        }
        return pattern.equals(url);
    }

    public String element(String name) {
        String[] patterns = this.pattern.split("/");
        String[] urls = this.url.split("/");
        int patternPointer = 0;
        for (int urlPointer = 0; patternPointer < patterns.length && urlPointer < urls.length; ++patternPointer, ++urlPointer) {
            String pattern = patterns[patternPointer];
            String url = urls[urlPointer];
            if (!pattern.equals(":" + name)) continue;
            return url;
        }
        return null;
    }

    public String getUrl() {
        return this.url;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public Path(String url, String pattern) {
        this.url = url;
        this.pattern = pattern;
    }

    public Path() {
    }
}

