/*
 * Decompiled with CFR 0.152.
 */
package ch.oliumbi.compass.sql;

import ch.oliumbi.compass.sql.Sql;
import ch.oliumbi.compass.sql.exceptions.CompassSqlException;
import ch.oliumbi.compass.sql.input.InputService;
import ch.oliumbi.compass.sql.output.OutputService;
import ch.oliumbi.compass.sql.pool.Pool;
import ch.oliumbi.compass.sql.pool.PoolConnection;
import ch.oliumbi.compass.sql.query.Query;
import ch.oliumbi.compass.sql.query.QueryService;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSql
implements Sql {
    public static final Logger LOGGER = LoggerFactory.getLogger(AbstractSql.class);
    private final Pool pool;
    private final QueryService queryService = new QueryService();
    private final InputService inputService = new InputService();
    private final OutputService outputService = new OutputService();

    public AbstractSql() {
        this.pool = new Pool(this.jdbc(), this.username(), this.password(), this.poolSize(), this.poolInitial());
    }

    @Override
    public int poolSize() {
        return 5;
    }

    @Override
    public int poolInitial() {
        return 2;
    }

    @Override
    public PoolConnection connection() throws CompassSqlException {
        return this.pool.lease();
    }

    @Override
    public boolean connected() {
        return this.pool.connected();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> Optional<List<T>> query(String sql, Class<T> output, Object ... inputs) {
        try (PoolConnection connection = this.pool.lease();){
            Query query = this.queryService.parse(sql);
            if (query.outputs().isEmpty()) {
                LOGGER.error("No into clause defined, maybe you want to use update() instead");
                Optional<List<T>> optional = Optional.empty();
                return optional;
            }
            PreparedStatement preparedStatement = connection.preparedStatement(query.executable());
            preparedStatement = this.inputService.build(preparedStatement, query.inputs(), List.of(inputs));
            ResultSet resultSet = preparedStatement.executeQuery();
            Optional<List<T>> optional = Optional.of(this.outputService.resolve(resultSet, output, query.outputs()));
            return optional;
        }
        catch (Exception e) {
            LOGGER.error("Exception occurred while executing sql query", (Throwable)e);
            return Optional.empty();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> Optional<T> querySingle(String sql, Class<T> output, Object ... inputs) {
        try (PoolConnection connection = this.pool.lease();){
            Query query = this.queryService.parse(sql);
            if (query.outputs().isEmpty()) {
                LOGGER.error("No into clause defined, maybe you want to use update() instead");
                Optional optional = Optional.empty();
                return optional;
            }
            PreparedStatement preparedStatement = connection.preparedStatement(query.executable());
            ResultSet resultSet = (preparedStatement = this.inputService.build(preparedStatement, query.inputs(), List.of(inputs))).executeQuery();
            List<T> result = this.outputService.resolve(resultSet, output, query.outputs());
            if (result.size() > 1) {
                LOGGER.error("Query returned multiple results, either query is invalid or query() should be used");
                Optional optional = Optional.empty();
                return optional;
            }
            if (result.isEmpty()) {
                LOGGER.warn("Query returned no results, either query is invalid or query() should be used");
                Optional optional = Optional.empty();
                return optional;
            }
            Optional<T> optional = Optional.of(result.getFirst());
            return optional;
        }
        catch (Exception e) {
            LOGGER.error("Exception occurred while executing sql query", (Throwable)e);
            return Optional.empty();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Integer> update(String sql, Object ... inputs) {
        try (PoolConnection connection = this.pool.lease();){
            Query query = this.queryService.parse(sql);
            if (!query.outputs().isEmpty()) {
                LOGGER.error("Into clause defined, maybe you want to use update() instead");
                Optional<Integer> optional = Optional.empty();
                return optional;
            }
            PreparedStatement preparedStatement = connection.preparedStatement(query.executable());
            preparedStatement = this.inputService.build(preparedStatement, query.inputs(), List.of(inputs));
            Optional<Integer> optional = Optional.of(preparedStatement.executeUpdate());
            return optional;
        }
        catch (Exception e) {
            LOGGER.error("Exception occurred while executing sql query", (Throwable)e);
            return Optional.empty();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Boolean> exists(String sql, Object ... inputs) {
        try (PoolConnection connection = this.pool.lease();){
            Query query = this.queryService.parse(sql);
            if (!query.outputs().isEmpty()) {
                LOGGER.error("Into clause defined, maybe you want to use update() instead");
                Optional<Boolean> optional = Optional.empty();
                return optional;
            }
            PreparedStatement preparedStatement = connection.preparedStatement(query.executable());
            preparedStatement = this.inputService.build(preparedStatement, query.inputs(), List.of(inputs));
            ResultSet resultSet = preparedStatement.executeQuery();
            Optional<Boolean> optional = Optional.of(this.outputService.exists(resultSet));
            return optional;
        }
        catch (Exception e) {
            LOGGER.error("Exception occurred while executing sql query", (Throwable)e);
            return Optional.empty();
        }
    }
}

