/*
 * Decompiled with CFR 0.152.
 */
package ch.oliumbi.compass.sql.output;

import ch.oliumbi.compass.core.exceptions.CompassReflectionException;
import ch.oliumbi.compass.core.reflection.Reflection;
import ch.oliumbi.compass.sql.exceptions.CompassSqlException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputService {
    public static final Logger LOGGER = LoggerFactory.getLogger(OutputService.class);

    public <T> List<T> resolve(ResultSet resultSet, Class<T> clazzOutput, List<String> queryOutputs) throws CompassSqlException, CompassReflectionException {
        ArrayList<Object> outputs = new ArrayList<Object>();
        try {
            while (resultSet.next()) {
                Object output = Reflection.instantiate(clazzOutput, (Object[])new Object[0]);
                for (int i = 0; i < queryOutputs.size(); ++i) {
                    String queryOutput = queryOutputs.get(i);
                    Field field = Reflection.field(clazzOutput, (String)queryOutput);
                    Object value = this.value(resultSet, field.getType(), i + 1);
                    Reflection.fieldSet((Object)output, (String)queryOutput, (Object)this.convert(value, field.getType()));
                }
                outputs.add(output);
            }
        }
        catch (SQLException e) {
            LOGGER.error("Failed to read next value of result set", (Throwable)e);
            throw new CompassSqlException();
        }
        return outputs;
    }

    public boolean exists(ResultSet resultSet) throws CompassSqlException {
        try {
            resultSet.next();
            return resultSet.getBoolean(1);
        }
        catch (SQLException e) {
            LOGGER.error("Failed to read exists result", (Throwable)e);
            throw new CompassSqlException();
        }
    }

    private Object value(ResultSet resultSet, Class<?> type, int index) throws CompassSqlException {
        try {
            if (type == byte[].class) {
                return resultSet.getBytes(index);
            }
            if (type.isEnum()) {
                return resultSet.getString(index);
            }
            return resultSet.getObject(index, type);
        }
        catch (SQLException e) {
            LOGGER.error("Failed to convert value", (Throwable)e);
            throw new CompassSqlException();
        }
    }

    private Object convert(Object value, Class<?> outputType) throws CompassSqlException, CompassReflectionException {
        if (outputType.isEnum()) {
            String enumString = (String)value;
            return Reflection.invoke((Method)Reflection.method(outputType, (String)"valueOf", (Class[])new Class[]{String.class}), null, (Object[])new Object[]{enumString});
        }
        return value;
    }
}

