/*
 * Decompiled with CFR 0.152.
 */
package ch.oliumbi.compass.sql.pool;

import ch.oliumbi.compass.sql.AbstractSql;
import ch.oliumbi.compass.sql.exceptions.CompassSqlException;
import ch.oliumbi.compass.sql.pool.PoolConnection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;

public class Pool {
    private final String jdbc;
    private final String username;
    private final String password;
    private BlockingQueue<PoolConnection> pool;

    public Pool(String jdbc, String username, String password, int size, int initial) {
        this.jdbc = jdbc;
        this.username = username;
        this.password = password;
        size = size > 0 ? size : 5;
        initial = initial > 0 ? initial : 2;
        this.pool = new LinkedBlockingDeque<PoolConnection>(size);
        for (int i = 0; i < initial; ++i) {
            try {
                this.open();
                continue;
            }
            catch (CompassSqlException e) {
                AbstractSql.LOGGER.error("Failed to initialize Sql connection, jdbc " + jdbc);
                throw new RuntimeException();
            }
        }
    }

    public PoolConnection lease() throws CompassSqlException {
        try {
            PoolConnection poolConnection;
            if (this.pool.peek() == null && this.pool.remainingCapacity() != 0) {
                this.open();
            }
            if ((poolConnection = this.pool.take()).isClosed()) {
                poolConnection = this.connect();
            }
            return poolConnection;
        }
        catch (SQLException e) {
            AbstractSql.LOGGER.error("Database access error occurred, while checking if connection is closed", (Throwable)e);
            throw new CompassSqlException();
        }
        catch (InterruptedException e) {
            AbstractSql.LOGGER.error("Pool got interrupted", (Throwable)e);
            throw new CompassSqlException();
        }
    }

    public void surrender(PoolConnection poolConnection) {
        this.pool.offer(poolConnection);
    }

    public boolean connected() {
        return this.pool.stream().anyMatch(poolConnection -> {
            try {
                return !poolConnection.isClosed();
            }
            catch (SQLException e) {
                AbstractSql.LOGGER.error("Database access error occurred, while checking if connection is closed", (Throwable)e);
                return false;
            }
        });
    }

    private synchronized void open() throws CompassSqlException {
        if (this.pool.remainingCapacity() == 0) {
            return;
        }
        this.pool.offer(this.connect());
    }

    private PoolConnection connect() throws CompassSqlException {
        try {
            AbstractSql.LOGGER.info("Connecting to " + this.jdbc);
            return new PoolConnection(this, DriverManager.getConnection(this.jdbc, this.username, this.password));
        }
        catch (SQLTimeoutException e) {
            AbstractSql.LOGGER.error("Timeout exceeded, while creating connection", (Throwable)e);
            throw new CompassSqlException();
        }
        catch (SQLException e) {
            AbstractSql.LOGGER.error("Database access error occurred or the url is null, while creating connection", (Throwable)e);
            throw new CompassSqlException();
        }
    }
}

