/*
 * Decompiled with CFR 0.152.
 */
package ch.oliumbi.compass.ui;

import ch.oliumbi.compass.core.enums.Language;
import ch.oliumbi.compass.ui.component.Component;
import ch.oliumbi.compass.ui.component.Render;
import ch.oliumbi.compass.ui.font.Font;
import java.util.List;
import java.util.stream.Collectors;

public abstract class Ui {
    protected abstract String title();

    protected abstract String description();

    protected abstract Language language();

    protected abstract String theme();

    protected abstract String foreground();

    protected abstract String background();

    protected abstract String icon();

    protected abstract String iconType();

    protected abstract String image();

    protected abstract String url();

    protected abstract String manifest();

    protected abstract List<Font> fonts();

    public String render(List<Component> components) {
        StringBuilder body = new StringBuilder();
        StringBuilder script = new StringBuilder();
        StringBuilder xl = new StringBuilder();
        StringBuilder l = new StringBuilder();
        StringBuilder m = new StringBuilder();
        StringBuilder s = new StringBuilder();
        StringBuilder xs = new StringBuilder();
        for (Component component : components) {
            Render render = component.render();
            body.append(render.getValue());
            script.append(render.getScript());
            xl.append(render.getXl());
            l.append(render.getL());
            m.append(render.getM());
            s.append(render.getS());
            xs.append(render.getXs());
        }
        return ("<!doctype html>\n<html lang=\"" + this.language().translate() + "\">\n  <head>\n    <meta charset=\"UTF-8\">\n\n    <title>" + this.title() + "</title>\n    <meta name=\"description\" content=\"" + this.description() + "\">\n    <meta name=\"theme-color\" content=\"" + this.theme() + "\">\n    <link rel=\"icon\" href=\"" + this.icon() + "\" type=\"" + this.iconType() + "\">\n    <link rel=\"manifest\" href=\"" + this.manifest() + "\" />\n\n    <meta property=\"og:type\" content=\"website\" />\n    <meta property=\"og:url\" content=\"" + this.url() + "\" />\n    <meta property=\"og:title\" content=\"" + this.title() + "\" />\n    <meta property=\"og:description\" content=\"" + this.description() + "\" />\n    <meta property=\"og:image\" content=\"" + this.image() + "\" />\n\n    <meta property=\"twitter:card\" content=\"summary_large_image\" />\n    <meta property=\"twitter:url\" content=\"" + this.url() + "\" />\n    <meta property=\"twitter:title\" content=\"" + this.title() + "\" />\n    <meta property=\"twitter:description\" content=\"" + this.description() + "\" />\n    <meta property=\"twitter:image\" content=\"" + this.image() + "\" />\n\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=5.0\">\n    <meta http-equiv=\"X-UA-Compatible\" content=\"ie=edge\">\n\n    <style>\n      " + this.normalize() + "\n      " + this.fonts().stream().map(Font::render).collect(Collectors.joining()) + "\n\n      " + String.valueOf(xl) + "\n      @media only screen and (max-width: 1280px) {\n        " + String.valueOf(l) + "\n      }\n      @media only screen and (max-width: 960px) {\n        " + String.valueOf(m) + "\n      }\n      @media only screen and (max-width: 640px) {\n        " + String.valueOf(s) + "\n      }\n      @media only screen and (max-width: 320px) {\n        " + String.valueOf(xs) + "\n      }\n    </style>\n  </head>\n  <body>\n    " + String.valueOf(body) + "\n    <script>\n      " + this.setup() + "\n      " + String.valueOf(script) + "\n    </script>\n  </body>\n</html\n").replaceAll("\n", "").replaceAll(" +", " ");
    }

    protected String normalize() {
        return "*, ::before, ::after {\n  box-sizing: border-box;\n}\n\nhtml {\n  font-family: system-ui, 'Segoe UI', Roboto, Helvetica, Arial, sans-serif, 'Apple Color Emoji', 'Segoe UI Emoji';\n  line-height: 1.15;\n  -webkit-text-size-adjust: 100%;\n  -moz-tab-size: 4;\n  tab-size: 4;\n}\n\nbody {\n  margin: 0;\n}\n\nhr {\n  height: 0;\n  color: inherit;\n}\n\nabbr[title] {\n  text-decoration: underline dotted;\n}\n\nb, strong {\n  font-weight: bolder;\n}\n\ncode, kbd, samp, pre {\n  font-family: ui-monospace, SFMono-Regular, Consolas, 'Liberation Mono', Menlo, monospace;\n  font-size: 1em;\n}\n\nsmall {\n  font-size: 80%;\n}\n\nsub, sup {\n  font-size: 75%;\n  line-height: 0;\n  position: relative;\n  vertical-align: baseline;\n}\n\nsub {\n  bottom: -0.25em;\n}\n\nsup {\n  top: -0.5em;\n}\n\ntable {\n  text-indent: 0;\n  border-color: inherit;\n}\n\nbutton, input, optgroup, select, textarea {\n  font-family: inherit;\n  font-size: 100%;\n  line-height: 1.15;\n  margin: 0;\n}\n\nbutton, select {\n  text-transform: none;\n}\n\nbutton, [type='button'], [type='reset'], [type='submit'] {\n  -webkit-appearance: button;\n}\n\n::-moz-focus-inner {\n  border-style: none;\n  padding: 0;\n}\n\n:-moz-focusring {\n  outline: 1px dotted ButtonText;\n}\n\n:-moz-ui-invalid {\n  box-shadow: none;\n}\n\nlegend {\n  padding: 0;\n}\n\nprogress {\n  vertical-align: baseline;\n}\n\n::-webkit-inner-spin-button, ::-webkit-outer-spin-button {\n  height: auto;\n}\n\n[type='search'] {\n  -webkit-appearance: textfield;\n  outline-offset: -2px;\n}\n\n::-webkit-search-decoration {\n  -webkit-appearance: none;\n}\n\n::-webkit-file-upload-button {\n  -webkit-appearance: button;\n  font: inherit;\n}\n\nsummary {\n  display: list-item;\n}\n\nh1, h2, h3, h4, h5, h6, p, small, blockquote {\n  margin: 0;\n  word-break: break-word;\n}\n\nimg {\n  display: block;\n  max-inline-size: 100%;\n  max-height: 100%;\n  max-width: 100%;\n}\n\nol, ul {\n  list-style: none;\n  padding-inline: 0;\n}\n\na {\n  text-decoration: none;\n  color: inherit;\n}\n\nbody {\n  background-color: " + this.background() + ";\n  color: " + this.foreground() + ";\n}\n";
    }

    protected String setup() {
        return "let listeners = [];\n\nlet event = (name) => {\n  for (const listener of listeners) {\n    if (listener.name === name) {\n      listener.callback();\n    }\n  }\n};\n";
    }
}

