/*
 * Decompiled with CFR 0.152.
 */
package ch.oliumbi.compass.ui.component;

import ch.oliumbi.compass.ui.attribute.Attribute;
import ch.oliumbi.compass.ui.component.Render;
import ch.oliumbi.compass.ui.script.Script;
import ch.oliumbi.compass.ui.style.Style;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;

public abstract class Component {
    protected String id = this.hash();

    protected abstract String tag();

    protected List<Component> components() {
        return new ArrayList<Component>();
    }

    protected String value() {
        return "";
    }

    protected List<Attribute> attributes() {
        return Collections.emptyList();
    }

    protected boolean error() {
        return false;
    }

    protected boolean disabled() {
        return false;
    }

    protected List<Script> scripts() {
        return Collections.emptyList();
    }

    protected List<Style> xl() {
        return Collections.emptyList();
    }

    protected List<Style> xlHover() {
        return Collections.emptyList();
    }

    protected List<Style> xlAction() {
        return Collections.emptyList();
    }

    protected List<Style> xlFocus() {
        return Collections.emptyList();
    }

    protected List<Style> xlDisabled() {
        return Collections.emptyList();
    }

    protected List<Style> xlError() {
        return Collections.emptyList();
    }

    protected List<Style> xlFadeFrom() {
        return Collections.emptyList();
    }

    protected List<Style> xlFadeTo() {
        return Collections.emptyList();
    }

    protected List<Style> l() {
        return Collections.emptyList();
    }

    protected List<Style> lHover() {
        return Collections.emptyList();
    }

    protected List<Style> lAction() {
        return Collections.emptyList();
    }

    protected List<Style> lFocus() {
        return Collections.emptyList();
    }

    protected List<Style> lDisabled() {
        return Collections.emptyList();
    }

    protected List<Style> lError() {
        return Collections.emptyList();
    }

    protected List<Style> lFadeFrom() {
        return Collections.emptyList();
    }

    protected List<Style> lFadeTo() {
        return Collections.emptyList();
    }

    protected List<Style> m() {
        return Collections.emptyList();
    }

    protected List<Style> mHover() {
        return Collections.emptyList();
    }

    protected List<Style> mAction() {
        return Collections.emptyList();
    }

    protected List<Style> mFocus() {
        return Collections.emptyList();
    }

    protected List<Style> mDisabled() {
        return Collections.emptyList();
    }

    protected List<Style> mError() {
        return Collections.emptyList();
    }

    protected List<Style> mFadeFrom() {
        return Collections.emptyList();
    }

    protected List<Style> mFadeTo() {
        return Collections.emptyList();
    }

    protected List<Style> s() {
        return Collections.emptyList();
    }

    protected List<Style> sHover() {
        return Collections.emptyList();
    }

    protected List<Style> sAction() {
        return Collections.emptyList();
    }

    protected List<Style> sFocus() {
        return Collections.emptyList();
    }

    protected List<Style> sDisabled() {
        return Collections.emptyList();
    }

    protected List<Style> sError() {
        return Collections.emptyList();
    }

    protected List<Style> sFadeFrom() {
        return Collections.emptyList();
    }

    protected List<Style> sFadeTo() {
        return Collections.emptyList();
    }

    protected List<Style> xs() {
        return Collections.emptyList();
    }

    protected List<Style> xsHover() {
        return Collections.emptyList();
    }

    protected List<Style> xsAction() {
        return Collections.emptyList();
    }

    protected List<Style> xsFocus() {
        return Collections.emptyList();
    }

    protected List<Style> xsDisabled() {
        return Collections.emptyList();
    }

    protected List<Style> xsError() {
        return Collections.emptyList();
    }

    protected List<Style> xsFadeFrom() {
        return Collections.emptyList();
    }

    protected List<Style> xsFadeTo() {
        return Collections.emptyList();
    }

    public String renderScript(String id) {
        if (this.scripts().isEmpty()) {
            return "";
        }
        StringBuilder render = new StringBuilder("{\n  let component = document.getElementById(\"" + id + "\");\n");
        for (Script script : this.scripts()) {
            render.append(script.render());
        }
        render.append("}\n");
        return render.toString();
    }

    public String renderStyle(String id, List<Style> normal, List<Style> hover, List<Style> action, List<Style> focus, List<Style> disabled, List<Style> error, List<Style> fadeFrom, List<Style> fadeTo) {
        StringBuilder render = new StringBuilder();
        if (!normal.isEmpty()) {
            render.append("#" + id + " {\n  transition: 150ms all ease-out;\n  " + normal.stream().map(Style::render).collect(Collectors.joining()) + "\n}\n");
        }
        if (!hover.isEmpty()) {
            render.append("#" + id + ":hover {\n  " + hover.stream().map(Style::render).collect(Collectors.joining()) + "\n}\n");
        }
        if (!action.isEmpty()) {
            render.append("#" + id + ":active {\n  " + action.stream().map(Style::render).collect(Collectors.joining()) + "\n}\n");
        }
        if (!focus.isEmpty()) {
            render.append("#" + id + ":focus-visible {\n  " + focus.stream().map(Style::render).collect(Collectors.joining()) + "\n}\n");
        }
        if (!disabled.isEmpty()) {
            render.append("#" + id + ":disabled {\n  " + disabled.stream().map(Style::render).collect(Collectors.joining()) + "\n}\n");
        }
        if (!error.isEmpty()) {
            render.append("#" + id + "[data-error=true] {\n  " + error.stream().map(Style::render).collect(Collectors.joining()) + "\n}\n");
        }
        if (!fadeFrom.isEmpty() && !fadeTo.isEmpty()) {
            render.append("#" + id + " {\n  animation: " + id + " linear both;\n  animation-timeline: view();\n  animation-range: entry 50% cover 50%;\n}\n\n@keyframes " + id + " {\n  from {\n    " + fadeFrom.stream().map(Style::render).collect(Collectors.joining()) + "\n  }\n  to {\n    " + fadeTo.stream().map(Style::render).collect(Collectors.joining()) + "\n  }\n}\n");
        }
        return render.toString();
    }

    public Render render() {
        Render render = new Render();
        List<Component> components = this.components();
        String tag = this.tag();
        StringBuilder value = new StringBuilder(StringEscapeUtils.escapeHtml4((String)this.value()));
        String attributes = this.attributes().stream().map(Attribute::render).collect(Collectors.joining(" "));
        StringBuilder script = new StringBuilder(this.renderScript(this.id));
        StringBuilder xl = new StringBuilder(this.renderStyle(this.id, this.xl(), this.xlHover(), this.xlAction(), this.xlFocus(), this.xlDisabled(), this.xlError(), this.xlFadeFrom(), this.xlFadeTo()));
        StringBuilder l = new StringBuilder(this.renderStyle(this.id, this.l(), this.lHover(), this.lAction(), this.lFocus(), this.lDisabled(), this.lError(), this.lFadeFrom(), this.lFadeTo()));
        StringBuilder m = new StringBuilder(this.renderStyle(this.id, this.m(), this.mHover(), this.mAction(), this.mFocus(), this.mDisabled(), this.mError(), this.mFadeFrom(), this.mFadeTo()));
        StringBuilder s = new StringBuilder(this.renderStyle(this.id, this.s(), this.sHover(), this.sAction(), this.sFocus(), this.sDisabled(), this.sError(), this.sFadeFrom(), this.sFadeTo()));
        StringBuilder xs = new StringBuilder(this.renderStyle(this.id, this.xs(), this.xsHover(), this.xsAction(), this.xsFocus(), this.xsDisabled(), this.xsError(), this.xsFadeFrom(), this.xsFadeTo()));
        for (Component component : components) {
            Render child = component.render();
            value.append(child.getValue());
            script.append(child.getScript());
            xl.append(child.getXl());
            l.append(child.getL());
            m.append(child.getM());
            s.append(child.getS());
            xs.append(child.getXs());
        }
        render.setValue("<" + tag + " id=\"" + this.id + "\" data-error=\"" + this.error() + "\" " + (this.disabled() ? "disabled" : "") + " " + attributes + ">" + value.toString() + "</" + tag + ">\n");
        render.setScript(script.toString());
        render.setXl(xl.toString());
        render.setL(l.toString());
        render.setM(m.toString());
        render.setS(s.toString());
        render.setXs(xs.toString());
        return render;
    }

    private String hash() {
        Random random = new Random();
        String options = "abcdefghijklmnopqrstuvwxyz";
        StringBuilder hash = new StringBuilder();
        for (int i = 0; i < 8; ++i) {
            hash.append(options.charAt(random.nextInt(options.length())));
        }
        return hash.toString();
    }
}

