/*
 * Decompiled with CFR 0.152.
 */
package ch.phatec.publibike.entities;

import ch.phatec.publibike.entities.AbstractEntity;
import ch.phatec.publibike.entities.VehicleType;
import com.google.gson.annotations.SerializedName;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Vehicle
extends AbstractEntity {
    private static final Logger LOG = LoggerFactory.getLogger(Vehicle.class);
    @SerializedName(value="ebike_battery_level")
    private BigDecimal ebikeBatteryLevel;
    private VehicleType type;

    public BigDecimal getEbikeBatteryLevel() {
        if (!this.isEBike().booleanValue()) {
            LOG.warn("Trying to get the battery level of a non electric vehicle (#" + this.getId() + ")");
        }
        return this.ebikeBatteryLevel;
    }

    public void setEbikeBatteryLevel(BigDecimal ebikeBatteryLevel) {
        this.ebikeBatteryLevel = ebikeBatteryLevel;
    }

    public VehicleType getType() {
        return this.type;
    }

    public void setType(VehicleType type) {
        this.type = type;
    }

    public Boolean isEBike() {
        return this.getType().getName().equals("E-Bike");
    }
}

