/*
 * Decompiled with CFR 0.152.
 */
package ch.phatec.publibike.network.requests;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Request<E> {
    private static final Logger LOG = LoggerFactory.getLogger(Request.class);

    protected abstract Class<E> getTargetClass();

    protected abstract HttpRequestBase getHttpRequest();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public E executeRequest() {
        try (CloseableHttpClient client = HttpClients.createDefault();){
            CloseableHttpResponse response = client.execute((HttpUriRequest)this.getHttpRequest());
            BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            String line = null;
            StringBuilder sb = new StringBuilder();
            while ((line = rd.readLine()) != null) {
                sb.append(line);
            }
            Object object = new Gson().fromJson(sb.toString(), this.getTargetClass());
            return (E)object;
        }
        catch (IOException e) {
            LOG.error("Request failed", (Throwable)e);
            return null;
        }
    }
}

