/*
 * Decompiled with CFR 0.152.
 */
package ch.phatec.publibike.network.utils;

import ch.phatec.publibike.network.utils.RequestType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(UrlBuilder.class);
    private static final Map<RequestType, String> URL_MAP = new HashMap<RequestType, String>();

    private UrlBuilder() {
    }

    public static URI build(RequestType type, Object ... params) {
        String url = String.format(URL_MAP.get((Object)type), params);
        LOG.trace("Build url string for a " + type + " request: " + url);
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            LOG.error("Failed to create an URI object for the request type " + type, (Throwable)e);
            return null;
        }
    }

    static {
        URL_MAP.put(RequestType.STATION, "https://api.publibike.ch/v1/public/stations/%d");
        URL_MAP.put(RequestType.STATIONS, "https://api.publibike.ch/v1/public/stations");
    }
}

