/*
 * Decompiled with CFR 0.152.
 */
package ch.pontius.nio.smb;

import ch.pontius.nio.smb.SMBDirectoryStream;
import ch.pontius.nio.smb.SMBFileAttributeView;
import ch.pontius.nio.smb.SMBFileAttributes;
import ch.pontius.nio.smb.SMBFileSystem;
import ch.pontius.nio.smb.SMBPath;
import ch.pontius.nio.smb.SeekableSMBByteChannel;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jcifs.Config;
import jcifs.smb.SmbFile;

public final class SMBFileSystemProvider
extends FileSystemProvider {
    private static final String PROPERTY_KEY_DOMAIN = "domain";
    private static final String PROPERTY_KEY_USERNAME = "username";
    private static final String PROPERTY_KEY_PASSWORD = "password";
    final Map<String, SMBFileSystem> fileSystemCache = new ConcurrentHashMap<String, SMBFileSystem>();

    @Override
    public String getScheme() {
        return "smb";
    }

    @Override
    public SMBFileSystem newFileSystem(URI uri, Map<String, ?> env) {
        String authority;
        if (!uri.getScheme().equals("smb")) {
            throw new IllegalArgumentException("The provided URI is not an SMB URI.");
        }
        if (uri.getAuthority().contains("@")) {
            authority = uri.getAuthority();
        } else {
            StringBuilder builder = new StringBuilder();
            if (env != null && !env.isEmpty()) {
                if (env.containsKey(PROPERTY_KEY_DOMAIN)) {
                    builder.append(env.get(PROPERTY_KEY_DOMAIN));
                    builder.append(";");
                }
                if (env.containsKey(PROPERTY_KEY_USERNAME)) {
                    builder.append(env.get(PROPERTY_KEY_USERNAME));
                    if (env.containsKey(PROPERTY_KEY_PASSWORD)) {
                        builder.append(":");
                        builder.append(env.get(PROPERTY_KEY_PASSWORD));
                    }
                }
            } else {
                if (Config.getProperty((String)"jcifs.smb.client.domain") != null) {
                    builder.append(Config.getProperty((String)"jcifs.smb.client.domain"));
                    builder.append(";");
                }
                if (Config.getProperty((String)"jcifs.smb.client.username") != null) {
                    builder.append(Config.getProperty((String)"jcifs.smb.client.username"));
                    if (Config.getProperty((String)"jcifs.smb.client.password") != null) {
                        builder.append(":");
                        builder.append(Config.getProperty((String)"jcifs.smb.client.password"));
                    }
                }
            }
            if (builder.length() > 0) {
                builder.append("@").append(uri.getAuthority());
                authority = builder.toString();
            } else {
                authority = uri.getAuthority();
            }
        }
        if (this.fileSystemCache.containsKey(authority)) {
            throw new FileSystemAlreadyExistsException("Filesystem for the provided server 'smb://" + authority + "' does already exist.");
        }
        SMBFileSystem system = new SMBFileSystem(this, authority);
        this.fileSystemCache.put(authority, system);
        return system;
    }

    @Override
    public SMBFileSystem getFileSystem(URI uri) {
        if (!uri.getScheme().equals("smb")) {
            throw new IllegalArgumentException("The provided URI is not an SMB URI.");
        }
        if (this.fileSystemCache.containsKey(uri.getAuthority())) {
            return this.fileSystemCache.get(uri.getAuthority());
        }
        throw new FileSystemNotFoundException("No filesystem for the provided server 'smb://" + uri.getAuthority() + "' could be found.");
    }

    @Override
    public SMBPath getPath(URI uri) {
        if (!uri.getScheme().equals("smb")) {
            throw new IllegalArgumentException("The provided URI is not an SMB URI.");
        }
        if (this.fileSystemCache.containsKey(uri.getAuthority())) {
            return new SMBPath(this.getFileSystem(uri), uri);
        }
        return new SMBPath((SMBFileSystem)this.newFileSystem(uri, (Map)new HashMap()), uri);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        SMBPath smbPath = SMBPath.fromPath(path);
        SmbFile file = smbPath.getSmbFile();
        boolean write = false;
        boolean create = false;
        boolean create_new = false;
        boolean append = false;
        boolean truncate = false;
        for (OpenOption openOption : options) {
            if (openOption.equals(StandardOpenOption.WRITE)) {
                write = true;
                continue;
            }
            if (openOption.equals(StandardOpenOption.CREATE)) {
                create = true;
                continue;
            }
            if (openOption.equals(StandardOpenOption.CREATE_NEW)) {
                create_new = true;
                continue;
            }
            if (openOption.equals(StandardOpenOption.APPEND)) {
                append = true;
                continue;
            }
            if (openOption.equals(StandardOpenOption.TRUNCATE_EXISTING)) {
                truncate = true;
                continue;
            }
            if (!openOption.equals(StandardOpenOption.DSYNC) && !openOption.equals(StandardOpenOption.SYNC) && !openOption.equals(StandardOpenOption.SPARSE) && !openOption.equals(StandardOpenOption.DELETE_ON_CLOSE)) continue;
            throw new UnsupportedOperationException("SMBFileSystemProvider does not support the option options SYNC, DSYNC, SPARSE or DELETE_ON_CLOSE");
        }
        return new SeekableSMBByteChannel(file, write, create, create_new, truncate, append);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return new SMBDirectoryStream(SMBPath.fromPath(dir), filter);
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        SmbFile smbFile = SMBPath.fromPath(dir).getSmbFile();
        smbFile.mkdir();
    }

    @Override
    public void delete(Path path) throws IOException {
        SmbFile smbFile = SMBPath.fromPath(path).getSmbFile();
        smbFile.delete();
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        SmbFile fromFile = SMBPath.fromPath(source).getSmbFile();
        SmbFile toFile = SMBPath.fromPath(target).getSmbFile();
        fromFile.copyTo(toFile);
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        SmbFile fromFile = SMBPath.fromPath(source).getSmbFile();
        SmbFile toFile = SMBPath.fromPath(target).getSmbFile();
        fromFile.renameTo(toFile);
    }

    @Override
    public boolean isSameFile(Path path1, Path path2) throws IOException {
        SmbFile smbFile1 = SMBPath.fromPath(path1).getSmbFile();
        SmbFile smbFile2 = SMBPath.fromPath(path2).getSmbFile();
        return smbFile1.equals((Object)smbFile2);
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        SmbFile smbFile = SMBPath.fromPath(path).getSmbFile();
        return smbFile.isHidden();
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        SmbFile smbFile = SMBPath.fromPath(path).getSmbFile();
        if (!smbFile.exists()) {
            throw new NoSuchFileException("The specified SMB resource does not exist.");
        }
        boolean checkRead = false;
        boolean checkWrite = false;
        for (AccessMode mode : modes) {
            if (mode.equals((Object)AccessMode.READ)) {
                checkRead = true;
            }
            if (!mode.equals((Object)AccessMode.WRITE)) continue;
            checkWrite = true;
        }
        if (checkRead && !smbFile.canRead()) {
            throw new AccessDeniedException("The specified SMB resource is not readable.");
        }
        if (checkWrite && !smbFile.canWrite()) {
            throw new AccessDeniedException("The specified SMB resource is not writable.");
        }
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        if (type == BasicFileAttributeView.class || type == SMBFileAttributeView.class) {
            return (V)new SMBFileAttributeView(SMBPath.fromPath(path));
        }
        return null;
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        if (type == BasicFileAttributes.class || type == SMBFileAttributes.class) {
            return (A)new SMBFileAttributes(SMBPath.fromPath(path).getSmbFile());
        }
        return null;
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        return null;
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException("Setting file attributes is currently not supported by SMBFileSystemProvider.");
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        throw new UnsupportedOperationException("Access to FileStore is currently not supported by SMBFileSystemProvider.");
    }
}

