/*
 * Decompiled with CFR 0.152.
 */
package ch.pontius.nio.smb;

public final class SMBPathUtil {
    private SMBPathUtil() {
    }

    public static boolean isFolder(String path) {
        return path.endsWith("/");
    }

    public static boolean isAbsolutePath(String path) {
        return path.startsWith("/");
    }

    public static boolean isRelativePath(String path) {
        return !path.startsWith("/");
    }

    public static String[] splitPath(String path) {
        String[] split = path.split("/");
        if (split.length > 0 && split[0].equals("")) {
            String[] truncated = new String[split.length - 1];
            System.arraycopy(split, 1, truncated, 0, split.length - 1);
            return truncated;
        }
        return split;
    }

    public static String mergePath(String[] components, int start, int end, boolean absolute, boolean folder) {
        StringBuilder builder = new StringBuilder();
        if (absolute) {
            builder.append("/");
        }
        for (int i = start; i < end; ++i) {
            builder.append(components[i]);
            builder.append("/");
        }
        if (!folder) {
            return builder.substring(0, builder.length() - 1);
        }
        return builder.toString();
    }
}

