/*
 * Decompiled with CFR 0.152.
 */
package ch.pontius.nio.smb;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import jcifs.smb.SmbException;

public final class SMBExceptionUtil {
    private SMBExceptionUtil() {
    }

    private static IOException translateToNIOException(SmbException e, String file, String other) {
        switch (e.getNtStatus()) {
            case -1073741790: {
                return new AccessDeniedException(file, other, e.getMessage());
            }
            case -1073741809: 
            case -1073741772: 
            case -1073741766: {
                return new NoSuchFileException(file, other, e.getMessage());
            }
            case -1073741771: {
                return new FileAlreadyExistsException(file, other, e.getMessage());
            }
        }
        return e;
    }

    static void rethrowAsNIOException(SmbException e, Path file, Path other) throws IOException {
        String a = file == null ? null : file.toString();
        String b = other == null ? null : other.toString();
        IOException x = SMBExceptionUtil.translateToNIOException(e, a, b);
        throw x;
    }

    static void rethrowAsNIOException(SmbException e, Path file) throws IOException {
        SMBExceptionUtil.rethrowAsNIOException(e, file, null);
    }
}

