/*
 * Decompiled with CFR 0.152.
 */
package ch.pontius.nio.smb;

import ch.pontius.nio.smb.SMBFileSystem;
import ch.pontius.nio.smb.SMBPathUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.ClosedFileSystemException;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import jcifs.CIFSContext;
import jcifs.smb.SmbFile;

public final class SMBPath
implements Path {
    private final SMBFileSystem fileSystem;
    private String[] components;
    private final boolean absolute;
    private final boolean folder;

    static SMBPath fromPath(Path path) {
        if (path instanceof SMBPath) {
            return (SMBPath)path;
        }
        throw new IllegalArgumentException("The provided path '" + path.toString() + "' is not an SMB path.");
    }

    SMBPath(SMBFileSystem fileSystem, URI uri) {
        if (!uri.getScheme().equals("smb")) {
            throw new IllegalArgumentException("The provided URI does not point to an SMB resource.");
        }
        this.folder = SMBPathUtil.isFolder(uri.getPath());
        this.absolute = SMBPathUtil.isAbsolutePath(uri.getPath());
        this.components = SMBPathUtil.splitPath(uri.getPath());
        this.fileSystem = fileSystem;
    }

    SMBPath(SMBFileSystem fileSystem, String path) {
        this.absolute = SMBPathUtil.isAbsolutePath(path);
        this.folder = SMBPathUtil.isFolder(path);
        this.components = SMBPathUtil.splitPath(path);
        this.fileSystem = fileSystem;
    }

    @Override
    public final FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public final boolean isAbsolute() {
        return this.absolute;
    }

    @Override
    public Path getRoot() {
        if (this.absolute) {
            return new SMBPath(this.fileSystem, "/");
        }
        return null;
    }

    @Override
    public Path getFileName() {
        return new SMBPath(this.fileSystem, this.components[this.components.length - 1]);
    }

    @Override
    public Path getParent() {
        if (this.components.length > 1) {
            String reduced = SMBPathUtil.mergePath(this.components, 0, this.components.length - 1, this.absolute, true);
            return new SMBPath(this.fileSystem, reduced);
        }
        return null;
    }

    @Override
    public int getNameCount() {
        return this.components.length;
    }

    @Override
    public Path getName(int index) {
        if (index < 0 || index >= this.components.length) {
            throw new IllegalArgumentException("The provided index is out of bounds.");
        }
        String reduced = SMBPathUtil.mergePath(this.components, index, index, false, index == this.components.length - 1 && this.folder);
        return new SMBPath(this.fileSystem, reduced);
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        if (beginIndex < 0 || endIndex >= this.components.length) {
            throw new IllegalArgumentException("The provided indices are out of bounds.");
        }
        if (beginIndex > endIndex) {
            throw new IllegalArgumentException("The beginIndex must be smaller than the endIndex.");
        }
        String reduced = SMBPathUtil.mergePath(this.components, beginIndex, endIndex, false, endIndex == this.components.length - 1 && this.folder);
        return new SMBPath(this.fileSystem, reduced);
    }

    @Override
    public boolean startsWith(Path other) {
        return other.getFileSystem() == this.fileSystem && this.startsWith(other.toString());
    }

    @Override
    public boolean startsWith(String other) {
        String path = SMBPathUtil.mergePath(this.components, 0, this.components.length, this.absolute, this.folder);
        return path.startsWith(other);
    }

    @Override
    public boolean endsWith(Path other) {
        return other.getFileSystem() == this.fileSystem && this.endsWith(other.toString());
    }

    @Override
    public boolean endsWith(String other) {
        String path = SMBPathUtil.mergePath(this.components, 0, this.components.length, this.absolute, this.folder);
        return path.endsWith(other);
    }

    @Override
    public Path normalize() {
        ArrayList<String> normalized = new ArrayList<String>();
        for (String component : this.components) {
            if (component.equals(".")) continue;
            if (component.equals("..") && normalized.size() > 1) {
                normalized.remove(normalized.size() - 1);
                continue;
            }
            if (component.equals("..") && normalized.size() > 0) continue;
            normalized.add(component);
        }
        String path = SMBPathUtil.mergePath(normalized.toArray(new String[normalized.size()]), 0, normalized.size(), this.absolute, this.folder);
        return new SMBPath(this.fileSystem, path);
    }

    @Override
    public Path resolve(Path other) {
        if (!(other instanceof SMBPath)) {
            throw new IllegalArgumentException("You can only resolve an SMB path against another SMB path.");
        }
        if (((SMBPath)other).fileSystem != this.fileSystem) {
            throw new IllegalArgumentException("You can only resolve an SMB path against another SMB path on the same file system.");
        }
        if (!this.isFolder()) {
            throw new IllegalArgumentException("The current path appears to be a file. You cannot resolve another path against a file path. Either add a trailing '/' to indicate that this is a folder or use resolveSibling() instead.");
        }
        if (other.isAbsolute()) {
            return other;
        }
        String[] components = new String[other.getNameCount() + this.getNameCount()];
        System.arraycopy(this.components, 0, components, 0, this.getNameCount());
        System.arraycopy(((SMBPath)other).components, 0, components, this.getNameCount(), other.getNameCount());
        String path = SMBPathUtil.mergePath(components, 0, components.length, this.absolute, ((SMBPath)other).folder);
        return new SMBPath(this.fileSystem, path);
    }

    @Override
    public Path resolve(String other) {
        if (!this.isFolder()) {
            throw new IllegalArgumentException("The current path appears to be a file. You cannot resolve another path against a file path. Either add a trailing '/' to indicate that this is a folder or use resolveSibling() instead.");
        }
        if (SMBPathUtil.isAbsolutePath(other)) {
            return new SMBPath(this.fileSystem, other);
        }
        String[] split = SMBPathUtil.splitPath(other);
        String[] components = new String[split.length + this.components.length];
        System.arraycopy(this.components, 0, components, 0, this.components.length);
        System.arraycopy(split, 0, components, this.components.length, split.length);
        String path = SMBPathUtil.mergePath(components, 0, components.length, this.absolute, SMBPathUtil.isFolder(other));
        return new SMBPath(this.fileSystem, path);
    }

    @Override
    public Path resolveSibling(Path other) {
        if (!(other instanceof SMBPath)) {
            throw new IllegalArgumentException("You can only resolve an SMB path against another SMB path.");
        }
        if (((SMBPath)other).fileSystem != this.fileSystem) {
            throw new IllegalArgumentException("You can only resolve an SMB path against another SMB path on the same file system.");
        }
        if (other.isAbsolute()) {
            return other;
        }
        String[] components = new String[other.getNameCount() + this.getNameCount() - 1];
        System.arraycopy(this.components, 0, components, 0, this.components.length - 1);
        System.arraycopy(((SMBPath)other).components, 0, components, this.components.length - 1, ((SMBPath)other).components.length);
        String path = SMBPathUtil.mergePath(components, 0, components.length, this.absolute, ((SMBPath)other).folder);
        return new SMBPath(this.fileSystem, path);
    }

    @Override
    public Path resolveSibling(String other) {
        if (!this.isFolder()) {
            throw new IllegalArgumentException("The current path appears to be a file. You cannot resolve another path against a file path. Either add a trailing '/' to indicate that this is a folder or use resolveSibling() instead.");
        }
        if (SMBPathUtil.isAbsolutePath(other)) {
            return new SMBPath(this.fileSystem, other);
        }
        String[] split = SMBPathUtil.splitPath(other);
        String[] components = new String[split.length + this.components.length - 1];
        System.arraycopy(this.components, 0, components, 0, this.components.length - 1);
        System.arraycopy(split, 0, components, this.components.length - 1, split.length);
        String path = SMBPathUtil.mergePath(components, 0, components.length, this.absolute, SMBPathUtil.isFolder(other));
        return new SMBPath(this.fileSystem, path);
    }

    @Override
    public Path relativize(Path other) {
        if (!(other instanceof SMBPath)) {
            throw new IllegalArgumentException("The provided path is not a SMBPath.");
        }
        SMBPath target = (SMBPath)other;
        if (this.fileSystem != target.fileSystem) {
            throw new IllegalArgumentException("The two paths do not belong to the same filesystem.");
        }
        if (this.absolute != target.absolute) {
            throw new IllegalArgumentException("The two paths are of a different type (absolute vs. relative).");
        }
        boolean common = true;
        int lastIndex = 0;
        ArrayList<String> newPath = new ArrayList<String>();
        for (int i = 0; i < this.components.length; ++i) {
            if (common) {
                if (i < target.components.length) {
                    if (this.components[i].equals(target.components[i])) {
                        ++lastIndex;
                        continue;
                    }
                    common = false;
                    newPath.add("..");
                    continue;
                }
                newPath.add("..");
                common = false;
                continue;
            }
            newPath.add("..");
        }
        if (lastIndex < target.components.length) {
            newPath.addAll(Arrays.asList(target.components).subList(lastIndex, target.components.length));
        }
        String[] array = new String[newPath.size()];
        String path = SMBPathUtil.mergePath(newPath.toArray(array), 0, newPath.size(), false, target.folder);
        return new SMBPath(this.fileSystem, path);
    }

    @Override
    public URI toUri() {
        String path = SMBPathUtil.mergePath(this.components, 0, this.components.length, this.absolute, this.folder);
        try {
            return new URI("smb", this.fileSystem.getName(), path, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("The current instance of SMBPath '" + this.toString() + "' cannot be transformed to a valid URI.");
        }
    }

    @Override
    public Path toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        return new SMBPath(this.fileSystem, "/").resolve(this);
    }

    @Override
    public Iterator<Path> iterator() {
        ArrayList<SMBPath> elements = new ArrayList<SMBPath>(this.components.length);
        for (int i = 0; i < this.components.length - 1; ++i) {
            elements.add(new SMBPath(this.fileSystem, this.components[i] + "/"));
        }
        elements.add(new SMBPath(this.fileSystem, this.components[this.components.length - 1] + (this.folder ? "/" : "")));
        return elements.iterator();
    }

    @Override
    public int compareTo(Path other) {
        if (!(other instanceof SMBPath)) {
            throw new IllegalArgumentException("You can only compare an SMB path against another SMB path.");
        }
        if (((SMBPath)other).fileSystem != this.fileSystem) {
            throw new IllegalArgumentException("You can only compare an SMB path against another SMB path on the same file system.");
        }
        String thisPath = SMBPathUtil.mergePath(this.components, 0, this.components.length, this.absolute, this.folder);
        String thatPath = SMBPathUtil.mergePath(((SMBPath)other).components, 0, ((SMBPath)other).components.length, ((SMBPath)other).absolute, ((SMBPath)other).folder);
        return thisPath.compareTo(thatPath);
    }

    @Override
    public String toString() {
        return SMBPathUtil.mergePath(this.components, 0, this.components.length, this.absolute, this.folder);
    }

    SmbFile getSmbFile() throws IOException {
        if (!this.fileSystem.isOpen()) {
            throw new ClosedFileSystemException();
        }
        String path = SMBPathUtil.mergePath(this.components, 0, this.components.length, this.absolute, this.folder);
        return new SmbFile(this.fileSystem.getFQN() + path, this.getContext());
    }

    private CIFSContext getContext() {
        return this.fileSystem.getContext();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof SMBPath)) {
            return false;
        }
        if (((SMBPath)other).fileSystem != this.fileSystem) {
            return false;
        }
        return Arrays.equals(this.components, ((SMBPath)other).components) && this.absolute == ((SMBPath)other).absolute && this.folder == ((SMBPath)other).folder;
    }

    public boolean isFolder() {
        return this.folder;
    }

    @Override
    public File toFile() {
        throw new UnsupportedOperationException("It is not possible to construct a file from a SMB path.");
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException("Symbolic links are currently not supported by SMB paths.");
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        throw new UnsupportedOperationException("FileWatchers are currently not supported by SMB paths.");
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        throw new UnsupportedOperationException("FileWatchers are currently not supported by SMB paths.");
    }
}

