/*
 * Decompiled with CFR 0.152.
 */
package ch.pontius.nio.smb;

import ch.pontius.nio.smb.SMBPath;
import java.io.IOException;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.TimeUnit;
import jcifs.smb.SmbFile;

public final class SMBFileAttributes
implements BasicFileAttributes {
    private final int attributes;
    private final long created;
    private final long modified;
    private final long length;
    private final int code;

    public SMBFileAttributes(SMBPath path) throws IOException {
        this(path.getSmbFile());
    }

    SMBFileAttributes(SmbFile file) throws IOException {
        this.attributes = file.getAttributes();
        this.created = file.createTime();
        this.modified = file.lastModified();
        this.length = file.length();
        this.code = file.hashCode();
    }

    @Override
    public FileTime lastModifiedTime() {
        return FileTime.from(this.modified, TimeUnit.MILLISECONDS);
    }

    @Override
    public FileTime lastAccessTime() {
        return FileTime.from(0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public FileTime creationTime() {
        return FileTime.from(this.created, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean isRegularFile() {
        return (this.attributes & 0x10) == 0;
    }

    @Override
    public boolean isDirectory() {
        return (this.attributes & 0x10) != 0;
    }

    @Override
    public boolean isSymbolicLink() {
        return false;
    }

    @Override
    public boolean isOther() {
        return false;
    }

    @Override
    public long size() {
        return this.length;
    }

    @Override
    public Object fileKey() {
        return this.code;
    }
}

