/*
 * Decompiled with CFR 0.152.
 */
package ch.pontius.nio.smb;

import ch.pontius.nio.smb.SMBFileAttributes;
import ch.pontius.nio.smb.SMBPath;
import java.io.IOException;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.TimeUnit;
import jcifs.smb.SmbFile;

public final class SMBFileAttributeView
implements BasicFileAttributeView {
    private final SMBPath path;

    public SMBFileAttributeView(SMBPath path) {
        this.path = path;
    }

    @Override
    public String name() {
        return "basic";
    }

    @Override
    public BasicFileAttributes readAttributes() throws IOException {
        return new SMBFileAttributes(this.path.getSmbFile());
    }

    @Override
    public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
        if (lastModifiedTime == null && lastAccessTime == null && createTime == null) {
            return;
        }
        long lastModified = lastModifiedTime != null ? lastModifiedTime.to(TimeUnit.MILLISECONDS) : 0L;
        long lastAccess = lastAccessTime != null ? lastAccessTime.to(TimeUnit.MILLISECONDS) : 0L;
        long create = createTime != null ? createTime.to(TimeUnit.MILLISECONDS) : 0L;
        SmbFile file = this.path.getSmbFile();
        file.setFileTimes(create, lastModified, lastAccess);
    }
}

