/*
 * Decompiled with CFR 0.152.
 */
package ch.pontius.nio.smb;

import ch.pontius.nio.smb.SMBDirectoryStream;
import ch.pontius.nio.smb.SMBExceptionUtil;
import ch.pontius.nio.smb.SMBFileAttributeView;
import ch.pontius.nio.smb.SMBFileAttributes;
import ch.pontius.nio.smb.SMBFileStore;
import ch.pontius.nio.smb.SMBFileSystem;
import ch.pontius.nio.smb.SMBPath;
import ch.pontius.nio.smb.SeekableSMBByteChannel;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jcifs.CIFSContext;
import jcifs.CIFSException;
import jcifs.Config;
import jcifs.Configuration;
import jcifs.Credentials;
import jcifs.SmbResource;
import jcifs.config.PropertyConfiguration;
import jcifs.context.BaseContext;
import jcifs.context.SingletonContext;
import jcifs.smb.NtlmPasswordAuthenticator;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SMBFileSystemProvider
extends FileSystemProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SMBFileSystemProvider.class);
    final Map<String, SMBFileSystem> fileSystemCache = new ConcurrentHashMap<String, SMBFileSystem>();

    @Override
    public String getScheme() {
        return "smb";
    }

    @Override
    public SMBFileSystem newFileSystem(URI uri, Map<String, ?> env) {
        if (!uri.getScheme().equals("smb")) {
            throw new IllegalArgumentException("The provided URI is not an SMB URI.");
        }
        try {
            CIFSContext context = this.contextFromMap(env);
            String authority = this.constructAuthority(uri, context);
            if (this.fileSystemCache.containsKey(authority)) {
                throw new FileSystemAlreadyExistsException("Filesystem for the provided server 'smb://" + authority + "' does already exist.");
            }
            SMBFileSystem system = new SMBFileSystem(this, authority, context);
            this.fileSystemCache.put(authority, system);
            return system;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Failed to URL encode the username and/or password in provided URI.", e);
        }
    }

    @Override
    public SMBFileSystem getFileSystem(URI uri) {
        if (!uri.getScheme().equals("smb")) {
            throw new IllegalArgumentException("The provided URI is not an SMB URI.");
        }
        try {
            CIFSContext context = this.contextFromMap(new HashMap());
            String authority = this.constructAuthority(uri, context);
            if (this.fileSystemCache.containsKey(authority)) {
                return this.fileSystemCache.get(authority);
            }
            throw new FileSystemNotFoundException("No filesystem for the provided server 'smb://" + uri.getAuthority() + "' could be found.");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Failed to URL encode the username and/or password in provided URI.", e);
        }
    }

    @Override
    public SMBPath getPath(URI uri) {
        if (!uri.getScheme().equals("smb")) {
            throw new IllegalArgumentException("The provided URI is not an SMB URI.");
        }
        try {
            CIFSContext context = this.contextFromMap(new HashMap());
            String authority = this.constructAuthority(uri, context);
            if (this.fileSystemCache.containsKey(authority)) {
                return new SMBPath(this.getFileSystem(uri), uri);
            }
            return new SMBPath((SMBFileSystem)this.newFileSystem(uri, (Map)new HashMap()), uri);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Failed to URL encode the username and/or password in provided URI.", e);
        }
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        SMBPath smbPath = SMBPath.fromPath(path);
        SmbFile file = smbPath.getSmbFile();
        boolean write = false;
        boolean create = false;
        boolean create_new = false;
        boolean append = false;
        boolean truncate = false;
        for (OpenOption openOption : options) {
            if (openOption.equals(StandardOpenOption.WRITE)) {
                write = true;
                continue;
            }
            if (openOption.equals(StandardOpenOption.CREATE)) {
                create = true;
                continue;
            }
            if (openOption.equals(StandardOpenOption.CREATE_NEW)) {
                create_new = true;
                continue;
            }
            if (openOption.equals(StandardOpenOption.APPEND)) {
                append = true;
                continue;
            }
            if (openOption.equals(StandardOpenOption.TRUNCATE_EXISTING)) {
                truncate = true;
                continue;
            }
            if (!openOption.equals(StandardOpenOption.DSYNC) && !openOption.equals(StandardOpenOption.SYNC) && !openOption.equals(StandardOpenOption.SPARSE) && !openOption.equals(StandardOpenOption.DELETE_ON_CLOSE)) continue;
            throw new UnsupportedOperationException("SMBFileSystemProvider does not support the option options SYNC, DSYNC, SPARSE or DELETE_ON_CLOSE");
        }
        return new SeekableSMBByteChannel(file, write, create, create_new, truncate, append);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return new SMBDirectoryStream(SMBPath.fromPath(dir), filter);
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        try (SmbFile smbFile = SMBPath.fromPath(dir).getSmbFile();){
            smbFile.mkdir();
        }
        catch (SmbException e) {
            SMBExceptionUtil.rethrowAsNIOException(e, dir);
        }
    }

    @Override
    public void delete(Path path) throws IOException {
        try (SmbFile smbFile = SMBPath.fromPath(path).getSmbFile();){
            smbFile.delete();
        }
        catch (SmbException e) {
            SMBExceptionUtil.rethrowAsNIOException(e, path);
        }
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        boolean replaceExisting = false;
        boolean copyAttributes = false;
        for (CopyOption opt : options) {
            if (opt == StandardCopyOption.REPLACE_EXISTING) {
                replaceExisting = true;
                continue;
            }
            if (opt != StandardCopyOption.COPY_ATTRIBUTES) continue;
            copyAttributes = true;
        }
        if (copyAttributes) {
            LOGGER.debug("Setting file attributes is currently not supported by SMBFileSystemProvider.");
        }
        try (SmbFile fromFile = SMBPath.fromPath(source).getSmbFile();
             SmbFile toFile = SMBPath.fromPath(target).getSmbFile();){
            if (!replaceExisting && toFile.exists()) {
                throw new FileAlreadyExistsException(toFile.toString(), null, "The specified SMB resource does already exist.");
            }
            fromFile.copyTo((SmbResource)toFile);
        }
        catch (SmbException e) {
            SMBExceptionUtil.rethrowAsNIOException(e, source, target);
        }
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        boolean replaceExisting = false;
        for (CopyOption opt : options) {
            if (opt != StandardCopyOption.REPLACE_EXISTING) continue;
            replaceExisting = true;
            break;
        }
        try (SmbFile fromFile = SMBPath.fromPath(source).getSmbFile();
             SmbFile toFile = SMBPath.fromPath(target).getSmbFile();){
            fromFile.renameTo((SmbResource)toFile, replaceExisting);
        }
        catch (SmbException e) {
            SMBExceptionUtil.rethrowAsNIOException(e, source, target);
        }
    }

    @Override
    public boolean isSameFile(Path path1, Path path2) throws IOException {
        SmbFile smbFile1 = SMBPath.fromPath(path1).getSmbFile();
        SmbFile smbFile2 = SMBPath.fromPath(path2).getSmbFile();
        return smbFile1.equals((Object)smbFile2);
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        boolean bl;
        block8: {
            SmbFile smbFile = SMBPath.fromPath(path).getSmbFile();
            try {
                bl = smbFile.isHidden();
                if (smbFile == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (smbFile != null) {
                        try {
                            smbFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SmbException e) {
                    SMBExceptionUtil.rethrowAsNIOException(e, path);
                    return false;
                }
            }
            smbFile.close();
        }
        return bl;
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        SmbFile smbFile = SMBPath.fromPath(path).getSmbFile();
        if (!smbFile.exists()) {
            throw new NoSuchFileException("The specified SMB resource does not exist.");
        }
        boolean checkRead = false;
        boolean checkWrite = false;
        for (AccessMode mode : modes) {
            if (mode.equals((Object)AccessMode.READ)) {
                checkRead = true;
            }
            if (!mode.equals((Object)AccessMode.WRITE)) continue;
            checkWrite = true;
        }
        if (checkRead && !smbFile.canRead()) {
            throw new AccessDeniedException("The specified SMB resource is not readable.");
        }
        if (checkWrite && !smbFile.canWrite()) {
            throw new AccessDeniedException("The specified SMB resource is not writable.");
        }
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        if (type == BasicFileAttributeView.class || type == SMBFileAttributeView.class) {
            return (V)new SMBFileAttributeView(SMBPath.fromPath(path));
        }
        return null;
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        if (type == BasicFileAttributes.class || type == SMBFileAttributes.class) {
            return (A)new SMBFileAttributes(SMBPath.fromPath(path).getSmbFile());
        }
        return null;
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) {
        return null;
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) {
        throw new UnsupportedOperationException("Setting file attributes is currently not supported by SMBFileSystemProvider.");
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        SMBPath smbPath = SMBPath.fromPath(path);
        String share = smbPath.getSmbFile().getShare();
        return new SMBFileStore((SMBFileSystem)smbPath.getFileSystem(), share);
    }

    private CIFSContext contextFromMap(Map<String, ?> env) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)System.getProperties());
        properties.putAll(env);
        try {
            BaseContext context = new BaseContext((Configuration)new PropertyConfiguration(properties));
            if (Config.getBoolean((Properties)properties, (String)"smb-nio.useNtlmPasswordAuthenticator", (boolean)false)) {
                Configuration config = context.getConfig();
                context = context.withCredentials((Credentials)new NtlmPasswordAuthenticator(config.getDefaultDomain(), config.getDefaultUsername(), config.getDefaultPassword()));
            }
            return context;
        }
        catch (CIFSException e) {
            LOGGER.warn("There was a problem when parsing CIFS configuration from environment map. Falling back to default context. Message:" + e.getMessage());
            return SingletonContext.getInstance();
        }
    }

    private String constructAuthority(URI uri, CIFSContext context) throws UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder();
        if (uri.getAuthority() != null && uri.getAuthority().contains("@")) {
            builder.append(uri.getAuthority());
        } else if (context != null) {
            if (context.getConfig().getDefaultDomain() != null) {
                builder.append(context.getConfig().getDefaultDomain());
                builder.append(";");
            }
            if (context.getConfig().getDefaultUsername() != null) {
                builder.append(URLEncoder.encode(context.getConfig().getDefaultUsername(), "UTF-8"));
                if (context.getConfig().getDefaultPassword() != null) {
                    builder.append(":");
                    builder.append(URLEncoder.encode(context.getConfig().getDefaultPassword(), "UTF-8"));
                }
            }
            if (uri.getAuthority() != null) {
                if (builder.length() > 0) {
                    builder.append("@").append(uri.getAuthority());
                } else {
                    builder.append(uri.getAuthority());
                }
            }
        }
        return builder.toString();
    }
}

