/*
 * Decompiled with CFR 0.152.
 */
package ch.pontius.nio.smb;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileAlreadyExistsException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbRandomAccessFile;

public final class SeekableSMBByteChannel
implements SeekableByteChannel {
    private final SmbRandomAccessFile random;
    private volatile boolean open = true;

    SeekableSMBByteChannel(SmbFile file, boolean write, boolean create, boolean create_new, boolean truncate, boolean append) throws IOException {
        if (create || create_new) {
            if (file.exists()) {
                if (create_new) {
                    throw new FileAlreadyExistsException("The specified file '" + file.getPath() + "' does already exist!");
                }
            } else {
                file.createNewFile();
            }
        }
        if (write) {
            this.random = new SmbRandomAccessFile(file, "rw");
            if (truncate) {
                this.random.setLength(0L);
            }
            if (append) {
                this.random.seek(this.random.length());
            }
        } else {
            this.random = new SmbRandomAccessFile(file, "r");
        }
    }

    @Override
    public synchronized int read(ByteBuffer dst) throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        int len = dst.limit() - dst.position();
        byte[] buffer = new byte[len];
        int read = this.random.read(buffer);
        if (read > 0) {
            dst.put(buffer, 0, read);
        }
        return read;
    }

    @Override
    public synchronized int write(ByteBuffer src) throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        int len = src.limit() - src.position();
        byte[] buffer = new byte[len];
        src.get(buffer);
        this.random.write(buffer);
        return len;
    }

    @Override
    public synchronized long position() throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        return this.random.getFilePointer();
    }

    @Override
    public synchronized long size() throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        return this.random.length();
    }

    @Override
    public synchronized SeekableByteChannel position(long newPosition) throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        this.random.seek(newPosition);
        return this;
    }

    @Override
    public synchronized SeekableByteChannel truncate(long size) throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        this.random.setLength(size);
        return this;
    }

    @Override
    public synchronized boolean isOpen() {
        return this.open;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.open) {
            this.open = false;
            this.random.close();
        }
    }
}

