/*
 * Decompiled with CFR 0.152.
 */
package ch.pontius.nio.smb;

import ch.pontius.nio.smb.SMBFileStore;
import ch.pontius.nio.smb.SMBFileSystemProvider;
import ch.pontius.nio.smb.SMBPath;
import ch.pontius.nio.smb.SMBPathMatcher;
import ch.pontius.nio.smb.SMBPathUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.ClosedFileSystemException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;

public final class SMBFileSystem
extends FileSystem {
    static final String PATH_SEPARATOR = "/";
    static final String SCHEME_SEPARATOR = "://";
    static final String CREDENTIALS_SEPARATOR = "@";
    static final String SMB_SCHEME = "smb";
    private static final Set<String> SUPPORTED_FILE_ATTRIBUTE_VIEWS = new HashSet<String>();
    private final String identifier;
    private final SMBFileSystemProvider provider;

    SMBFileSystem(SMBFileSystemProvider provider, String authority) {
        this.identifier = authority;
        this.provider = provider;
    }

    @Override
    public FileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public void close() {
        this.provider.fileSystemCache.remove(this.identifier);
    }

    @Override
    public boolean isOpen() {
        return this.provider.fileSystemCache.containsKey(this.identifier);
    }

    @Override
    public boolean isReadOnly() {
        if (!this.isOpen()) {
            throw new ClosedFileSystemException();
        }
        return false;
    }

    @Override
    public String getSeparator() {
        return PATH_SEPARATOR;
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        if (!this.isOpen()) {
            throw new ClosedFileSystemException();
        }
        try {
            SmbFile file = new SmbFile("smb://" + this.identifier, PATH_SEPARATOR);
            return Arrays.stream(file.list()).map(s -> new SMBPath(this, PATH_SEPARATOR + s)).collect(Collectors.toList());
        }
        catch (MalformedURLException | SmbException e) {
            return new ArrayList<Path>(0);
        }
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        if (!this.isOpen()) {
            throw new ClosedFileSystemException();
        }
        try {
            SmbFile file = new SmbFile("smb://" + this.identifier, PATH_SEPARATOR);
            return Arrays.stream(file.list()).map(s -> new SMBFileStore(this, (String)s)).collect(Collectors.toList());
        }
        catch (MalformedURLException | SmbException e) {
            return new ArrayList<FileStore>(0);
        }
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        if (!this.isOpen()) {
            throw new ClosedFileSystemException();
        }
        return SUPPORTED_FILE_ATTRIBUTE_VIEWS;
    }

    @Override
    public Path getPath(String first, String ... more) {
        if (!this.isOpen()) {
            throw new ClosedFileSystemException();
        }
        String[] components = new String[more.length + 1];
        components[0] = first;
        if (more.length > 0) {
            System.arraycopy(more, 0, components, 1, more.length);
        }
        String path = SMBPathUtil.mergePath(components, 0, components.length, first.startsWith(PATH_SEPARATOR), more[more.length - 1].endsWith(PATH_SEPARATOR));
        return new SMBPath(this, path);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        return new SMBPathMatcher(syntaxAndPattern);
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException("The SMBFileSystem does not support UserPrincipalLookupServices.");
    }

    @Override
    public WatchService newWatchService() throws IOException {
        throw new UnsupportedOperationException("The SMBFileSystem does not support WatchService.");
    }

    String getName() {
        return this.identifier;
    }

    String getFQN() {
        return "smb://" + this.identifier;
    }

    static {
        SUPPORTED_FILE_ATTRIBUTE_VIEWS.add("basic");
    }
}

