/*
 * Decompiled with CFR 0.152.
 */
package ch.pontius.nio.smb;

import java.nio.file.Path;
import java.nio.file.PathMatcher;

public class SMBPathMatcher
implements PathMatcher {
    private final String pattern;

    SMBPathMatcher(String pattern) {
        this.pattern = pattern.startsWith("glob:") ? SMBPathMatcher.globToRegex(pattern.replaceFirst("glob:", "")) : (pattern.startsWith("regex:") ? pattern.replaceFirst("regex:", "") : pattern);
    }

    private static String globToRegex(String globPattern) {
        if ((globPattern = globPattern.trim()).endsWith("*")) {
            globPattern = globPattern.substring(0, globPattern.length() - 1);
        }
        StringBuilder sb = new StringBuilder(globPattern.length());
        boolean escaping = false;
        int inCurlies = 0;
        block9: for (char currentChar : globPattern.toCharArray()) {
            switch (currentChar) {
                case '*': {
                    if (escaping) {
                        sb.append("\\*");
                    } else {
                        sb.append(".*");
                    }
                    escaping = false;
                    continue block9;
                }
                case '?': {
                    if (escaping) {
                        sb.append("\\?");
                    } else {
                        sb.append('.');
                    }
                    escaping = false;
                    continue block9;
                }
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '@': 
                case '^': 
                case '|': {
                    sb.append('\\');
                    sb.append(currentChar);
                    escaping = false;
                    continue block9;
                }
                case '\\': {
                    if (escaping) {
                        sb.append("\\\\");
                        escaping = false;
                        continue block9;
                    }
                    escaping = true;
                    continue block9;
                }
                case '{': {
                    if (escaping) {
                        sb.append("\\{");
                    } else {
                        sb.append('(');
                        ++inCurlies;
                    }
                    escaping = false;
                    continue block9;
                }
                case '}': {
                    if (inCurlies > 0 && !escaping) {
                        sb.append(')');
                        --inCurlies;
                    } else if (escaping) {
                        sb.append("\\}");
                    } else {
                        sb.append("}");
                    }
                    escaping = false;
                    continue block9;
                }
                case ',': {
                    if (inCurlies > 0 && !escaping) {
                        sb.append('|');
                        continue block9;
                    }
                    if (escaping) {
                        sb.append("\\,");
                        continue block9;
                    }
                    sb.append(",");
                    continue block9;
                }
                default: {
                    escaping = false;
                    sb.append(currentChar);
                }
            }
        }
        return sb.toString();
    }

    @Override
    public boolean matches(Path path) {
        return path.normalize().toString().matches(this.pattern);
    }
}

