/*
 * Decompiled with CFR 0.152.
 */
package ch.pontius.nio.smb;

import ch.pontius.nio.smb.SMBPath;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;

public final class SMBDirectoryStream
implements DirectoryStream<Path> {
    private final ArrayList<Path> content;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean iteratorReturned = new AtomicBoolean();

    public SMBDirectoryStream(SMBPath smbPath, DirectoryStream.Filter<? super Path> filter) throws IOException {
        if (!smbPath.getSmbFile().isDirectory()) {
            throw new NotDirectoryException("The provided path '" + smbPath.toString() + "' is not a directory.");
        }
        this.content = new ArrayList();
        for (String name : smbPath.getSmbFile().list()) {
            Path path = smbPath.resolve(name);
            if (filter != null && !filter.accept(path)) continue;
            this.content.add(path);
        }
    }

    @Override
    public Iterator<Path> iterator() {
        if (this.closed.get()) {
            throw new IllegalStateException("The SMBDirectoryStream has been closed already.");
        }
        if (this.iteratorReturned.get()) {
            throw new IllegalStateException("The current instance of SMBDirectoryStream has already returned an iterator.");
        }
        if (this.content != null) {
            this.iteratorReturned.compareAndSet(false, true);
            return this.content.iterator();
        }
        return new ArrayList(0).iterator();
    }

    @Override
    public void close() {
        this.closed.set(true);
    }
}

