/*
 * Decompiled with CFR 0.152.
 */
package ch.pontius.nio.smb;

import ch.pontius.nio.smb.SMBFileAttributeView;
import ch.pontius.nio.smb.SMBFileSystem;
import java.io.IOException;
import java.nio.file.ClosedFileSystemException;
import java.nio.file.FileStore;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileStoreAttributeView;
import jcifs.smb.SmbFile;

public final class SMBFileStore
extends FileStore {
    private final SMBFileSystem fileSystem;
    private final String share;

    SMBFileStore(SMBFileSystem fileSystem, String share) {
        this.fileSystem = fileSystem;
        this.share = share;
    }

    @Override
    public String name() {
        return this.fileSystem.getFQN() + "/" + this.share;
    }

    @Override
    public String type() {
        return "share";
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public long getTotalSpace() throws IOException {
        if (!this.fileSystem.isOpen()) {
            throw new ClosedFileSystemException();
        }
        return new SmbFile(this.name()).length();
    }

    @Override
    public long getUsableSpace() throws IOException {
        if (!this.fileSystem.isOpen()) {
            throw new ClosedFileSystemException();
        }
        return new SmbFile(this.name()).getDiskFreeSpace();
    }

    @Override
    public long getUnallocatedSpace() throws IOException {
        if (!this.fileSystem.isOpen()) {
            throw new ClosedFileSystemException();
        }
        return new SmbFile(this.name()).getDiskFreeSpace();
    }

    @Override
    public boolean supportsFileAttributeView(Class<? extends FileAttributeView> type) {
        return type.equals(BasicFileAttributeView.class) || type.equals(SMBFileAttributeView.class);
    }

    @Override
    public boolean supportsFileAttributeView(String name) {
        return name.equals("basic");
    }

    @Override
    public <V extends FileStoreAttributeView> V getFileStoreAttributeView(Class<V> type) {
        return null;
    }

    @Override
    public Object getAttribute(String attribute) throws IOException {
        throw new UnsupportedOperationException("File store attribute views are not supported for the current implementation of SMBFileStore.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SMBFileStore that = (SMBFileStore)o;
        return this.fileSystem.equals(that.fileSystem) && this.share.equals(that.share);
    }

    public int hashCode() {
        int result = this.fileSystem.hashCode();
        result = 31 * result + this.share.hashCode();
        return result;
    }
}

