/*
 * Decompiled with CFR 0.152.
 */
package org.ntlmv2.liferay;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import jcifs.dcerpc.DcerpcBinding;
import jcifs.dcerpc.DcerpcHandle;
import jcifs.dcerpc.DcerpcMessage;
import jcifs.dcerpc.UnicodeString;
import jcifs.smb.SmbException;
import org.ntlmv2.liferay.NetlogonConnection;
import org.ntlmv2.liferay.NtlmLogonException;
import org.ntlmv2.liferay.NtlmServiceAccount;
import org.ntlmv2.liferay.NtlmUserAccount;
import org.ntlmv2.liferay.ntlm.msrpc.NetlogonAuthenticator;
import org.ntlmv2.liferay.ntlm.msrpc.NetlogonIdentityInfo;
import org.ntlmv2.liferay.ntlm.msrpc.NetlogonNetworkInfo;
import org.ntlmv2.liferay.ntlm.msrpc.NetlogonValidationSamInfo;
import org.ntlmv2.liferay.ntlm.msrpc.NetrLogonSamLogon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Netlogon {
    private static Logger _log = LoggerFactory.getLogger(Netlogon.class);
    private String _domainController;
    private String _domainControllerName;
    private NtlmServiceAccount _ntlmServiceAccount;
    private SecureRandom _secureRandom = new SecureRandom();

    public NtlmUserAccount logon(String domain, String userName, String workstation, byte[] serverChallenge, byte[] ntResponse, byte[] lmResponse) throws NtlmLogonException {
        NetlogonConnection netlogonConnection = new NetlogonConnection();
        try {
            netlogonConnection.connect(this._domainController, this._domainControllerName, this._ntlmServiceAccount, this._secureRandom);
            NetlogonAuthenticator netlogonAuthenticator = netlogonConnection.computeNetlogonAuthenticator();
            NetlogonIdentityInfo netlogonIdentityInfo = new NetlogonIdentityInfo(domain, 2080, 0, 0, userName, workstation);
            NetlogonNetworkInfo netlogonNetworkInfo = new NetlogonNetworkInfo(netlogonIdentityInfo, serverChallenge, ntResponse, lmResponse);
            NetrLogonSamLogon netrLogonSamLogon = new NetrLogonSamLogon(this._domainControllerName, this._ntlmServiceAccount.getComputerName(), netlogonAuthenticator, new NetlogonAuthenticator(), 2, netlogonNetworkInfo, 2, new NetlogonValidationSamInfo(), 0);
            DcerpcHandle dcerpcHandle = netlogonConnection.getDcerpcHandle();
            dcerpcHandle.sendrecv((DcerpcMessage)netrLogonSamLogon);
            if (netrLogonSamLogon.getStatus() == 0) {
                NetlogonValidationSamInfo netlogonValidationSamInfo = netrLogonSamLogon.getNetlogonValidationSamInfo();
                UnicodeString name = new UnicodeString(netlogonValidationSamInfo.getEffectiveName(), false);
                NtlmUserAccount ntlmUserAccount = new NtlmUserAccount(name.toString());
                return ntlmUserAccount;
            }
            try {
                SmbException smbe = new SmbException(netrLogonSamLogon.getStatus(), false);
                throw new NtlmLogonException("Unable to authenticate user: " + smbe.getMessage());
            }
            catch (NoSuchAlgorithmException e) {
                throw new NtlmLogonException("Unable to authenticate due to invalid encryption algorithm", e);
            }
            catch (IOException e) {
                throw new NtlmLogonException("Unable to authenticate due to communication failure with server", e);
            }
        }
        finally {
            try {
                netlogonConnection.disconnect();
            }
            catch (Exception e) {
                _log.error("Unable to disconnect Netlogon connection", (Throwable)e);
            }
        }
    }

    public void setConfiguration(String domainController, String domainControllerName, NtlmServiceAccount ntlmServiceAccount) {
        this._domainController = domainController;
        this._domainControllerName = domainControllerName;
        this._ntlmServiceAccount = ntlmServiceAccount;
    }

    static {
        DcerpcBinding.addInterface((String)"netlogon", (String)"12345678-1234-abcd-ef00-01234567cffb:1.0");
    }
}

