/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.async.lang;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;

public interface WaitResultBuilder5<T> {
    public CompletableFuture<Optional<T>> asyncExec(Executor var1);

    default public CompletableFuture<Optional<T>> asyncExec() {
        return this.asyncExec(ForkJoinPool.commonPool());
    }

    default public Optional<T> finish() {
        try {
            return this.asyncExec().get();
        }
        catch (InterruptedException e) {
            throw new AssertionError("Unable to get the result, because of " + e.getMessage(), e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof AssertionError) {
                throw (AssertionError)((Object)e.getCause());
            }
            throw new AssertionError("Unexpected error " + e.getMessage(), e);
        }
    }

    default public T finishWithAResult() {
        return this.finish().orElseThrow(() -> new AssertionError((Object)"No result is available"));
    }
}

