/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.async.impl;

import ch.powerunit.extensions.async.impl.ExceptionHandler;
import ch.powerunit.extensions.async.lang.WaitResultBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public final class WaitResultImpl<T>
implements WaitResultBuilder<T>,
Callable<Optional<T>> {
    private final Callable<T> action;
    private final ExceptionHandler exceptionHandler;
    private final Predicate<T> acceptingClause;
    private final int count;
    private final long waitInMs;

    public WaitResultImpl(Callable<T> action) {
        this.action = Objects.requireNonNull(action, "action can't be null");
        this.exceptionHandler = new ExceptionHandler(false, false);
        this.acceptingClause = null;
        this.count = 0;
        this.waitInMs = 0L;
    }

    private WaitResultImpl(WaitResultImpl<T> prev, boolean ignoreException, boolean alsoDontFailWhenNoResultAndException) {
        this.action = prev.action;
        this.acceptingClause = prev.acceptingClause;
        this.count = prev.count;
        this.waitInMs = prev.waitInMs;
        this.exceptionHandler = new ExceptionHandler(ignoreException, alsoDontFailWhenNoResultAndException);
    }

    private WaitResultImpl(WaitResultImpl<T> prev, Predicate<T> acceptingClause) {
        this.action = prev.action;
        this.exceptionHandler = prev.exceptionHandler;
        this.count = prev.count;
        this.waitInMs = prev.waitInMs;
        this.acceptingClause = acceptingClause;
    }

    private WaitResultImpl(WaitResultImpl<T> prev, int count) {
        this.action = prev.action;
        this.exceptionHandler = prev.exceptionHandler;
        this.acceptingClause = prev.acceptingClause;
        this.waitInMs = prev.waitInMs;
        this.count = count;
    }

    private WaitResultImpl(WaitResultImpl<T> prev, long millis) {
        this.action = prev.action;
        this.exceptionHandler = prev.exceptionHandler;
        this.acceptingClause = prev.acceptingClause;
        this.count = prev.count;
        this.waitInMs = millis;
    }

    @Override
    public WaitResultImpl<T> ignoreException(boolean alsoDontFailWhenNoResultAndException) {
        return new WaitResultImpl<T>(this, true, alsoDontFailWhenNoResultAndException);
    }

    @Override
    public WaitResultImpl<T> expecting(Predicate<T> acceptingClause) {
        return new WaitResultImpl<T>(this, acceptingClause);
    }

    @Override
    public WaitResultImpl<T> repeat(int count) {
        return new WaitResultImpl<T>(this, count);
    }

    @Override
    public WaitResultImpl<T> every(int value, TimeUnit unit) {
        return new WaitResultImpl<T>(this, Objects.requireNonNull(unit, "unit can't be null").toMillis(value));
    }

    private void sleepBetweenRetry() {
        try {
            Thread.sleep(this.waitInMs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public Optional<T> get() {
        Exception prev = null;
        for (int i = 0; i < this.count; ++i) {
            prev = null;
            try {
                Object result = this.call();
                if (((Optional)result).isPresent()) {
                    return result;
                }
            }
            catch (Exception e) {
                prev = e;
                this.exceptionHandler.handleException(e);
            }
            this.sleepBetweenRetry();
        }
        this.exceptionHandler.handleFinalException(prev);
        return Optional.empty();
    }

    @Override
    public Optional<T> call() throws Exception {
        return Optional.ofNullable(this.action.call()).filter(this.acceptingClause);
    }
}

