/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.async.lang;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Supplier;

public interface WaitResultBuilder5<T>
extends Supplier<Optional<T>> {
    @Override
    public Optional<T> get();

    default public CompletableFuture<Optional<T>> asyncExec(Executor executor) {
        return CompletableFuture.supplyAsync(this);
    }

    default public CompletableFuture<Optional<T>> asyncExec() {
        return this.asyncExec(ForkJoinPool.commonPool());
    }

    default public Optional<T> finish(Executor executor) {
        try {
            return this.asyncExec(executor).get();
        }
        catch (InterruptedException e) {
            throw new AssertionError("Unable to get the result, because of " + e.getMessage(), e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof AssertionError) {
                throw (AssertionError)((Object)e.getCause());
            }
            throw new AssertionError("Unexpected error " + e.getMessage(), e);
        }
    }

    default public Optional<T> finish() {
        return this.finish(ForkJoinPool.commonPool());
    }

    default public T finishWithAResult(Executor executor) {
        return this.finish(executor).orElseThrow(() -> new AssertionError((Object)"No result is available"));
    }

    default public T finishWithAResult() {
        return this.finishWithAResult(ForkJoinPool.commonPool());
    }
}

