/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.async.impl;

import ch.powerunit.extensions.async.impl.ExceptionHandler;
import ch.powerunit.extensions.async.impl.RetryImpl;
import ch.powerunit.extensions.async.lang.RetryPolicy;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class WaitResultImpl<T>
implements Supplier<Optional<T>>,
Callable<Optional<T>> {
    private final Callable<Optional<T>> action;
    private final ExceptionHandler exceptionHandler;
    private final RetryPolicy retryClause;

    private static <T> Callable<Optional<T>> asCallable(Callable<T> action, Predicate<T> acceptingClause) {
        Objects.requireNonNull(action, "action can't be null");
        Objects.requireNonNull(acceptingClause, "acceptingClause can't be null");
        return () -> Optional.ofNullable(action.call()).filter(acceptingClause);
    }

    public WaitResultImpl(Callable<T> action, boolean alsoDontFailWhenNoResultAndException, Predicate<T> acceptingClause, RetryPolicy retryClause) {
        this.action = WaitResultImpl.asCallable(action, acceptingClause);
        this.exceptionHandler = new ExceptionHandler(true, alsoDontFailWhenNoResultAndException);
        this.retryClause = Objects.requireNonNull(retryClause, "retryClause can't be null");
    }

    public WaitResultImpl(Callable<T> action, Predicate<T> acceptingClause, RetryPolicy retryClause) {
        this.action = WaitResultImpl.asCallable(action, acceptingClause);
        this.exceptionHandler = new ExceptionHandler(false, false);
        this.retryClause = Objects.requireNonNull(retryClause, "retryClause can't be null");
    }

    @Override
    public Optional<T> get() {
        RetryImpl retry = new RetryImpl(this);
        while (retry.next()) {
            this.exceptionHandler.handleException(retry.getPreviousException());
            Optional result = retry.getResult();
            if (!result.isPresent()) continue;
            return result;
        }
        this.exceptionHandler.handleFinalException(retry.getPreviousException());
        return Optional.empty();
    }

    public RetryPolicy getRetryClause() {
        return this.retryClause;
    }

    @Override
    public Optional<T> call() throws Exception {
        return this.action.call();
    }
}

