/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.async.lang;

import ch.powerunit.extensions.async.lang.RetryPolicy;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.IntToLongFunction;

public final class RetryPolicies {
    public static final RetryPolicy RETRY_ONLY_ONCE = RetryPolicies.of(1, 1L);

    private RetryPolicies() {
    }

    public static RetryPolicy of(int count, long ms) {
        return RetryPolicies.of(count, (int l) -> ms);
    }

    public static RetryPolicy of(int count, long value, TimeUnit unit) {
        return RetryPolicies.of(count, Objects.requireNonNull(unit, "unit can't be null").toMillis(value));
    }

    public static RetryPolicy of(int count, Duration duration) {
        return RetryPolicies.of(count, Objects.requireNonNull(duration, "duration can't be null").toMillis());
    }

    public static RetryPolicy of(final int count, final IntToLongFunction retryToWaitTime) {
        return new RetryPolicy(){

            @Override
            public void sleepBetweenRetry(int retry) {
                RetryPolicies.sleepBetweenRetry(retryToWaitTime.applyAsLong(retry));
            }

            @Override
            public int getCount() {
                return count;
            }
        };
    }

    public static RetryPolicy ofIncremental(int count, long ms) {
        return RetryPolicies.of(count, (int retry) -> (long)retry * ms);
    }

    public static RetryPolicy ofIncremental(int count, Duration duration) {
        return RetryPolicies.ofIncremental(count, Objects.requireNonNull(duration, "duration can't be null").toMillis());
    }

    private static void sleepBetweenRetry(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

