/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.async.lang;

import ch.powerunit.extensions.async.impl.WaitResultImpl;
import ch.powerunit.extensions.async.lang.WaitResultBuilder1;
import ch.powerunit.extensions.async.lang.WaitResultBuilder2;
import ch.powerunit.extensions.async.lang.WaitResultBuilder3;
import ch.powerunit.extensions.async.lang.WaitResultBuilder5;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class WaitResult {
    private WaitResult() {
    }

    public static <T> WaitResultBuilder1<T> of(final Callable<T> action) {
        return new WaitResultBuilder1<T>(){

            @Override
            public WaitResultBuilder3<T> expecting(Predicate<T> acceptingClause) {
                return retry -> WaitResultBuilder5.of(new WaitResultImpl(action, acceptingClause, retry)::get);
            }

            @Override
            public WaitResultBuilder2<T> ignoreException(boolean alsoDontFailWhenNoResultAndException) {
                return predicate -> retry -> WaitResultBuilder5.of(new WaitResultImpl(action, alsoDontFailWhenNoResultAndException, predicate, retry)::get);
            }
        };
    }

    public static WaitResultBuilder3<Boolean> ofRunnable(Runnable action) {
        return WaitResult.of(Executors.callable(action, true)).ignoreException(true).expecting(b -> b);
    }

    public static <T> WaitResultBuilder2<T> on(T mutableObject) {
        return WaitResult.of(() -> mutableObject);
    }

    public static WaitResultBuilder3<Boolean> onCondition(Supplier<Boolean> conditionSupplier) {
        return WaitResult.of(conditionSupplier::get).expecting(b -> b);
    }

    public static WaitResultBuilder3<Exception> forException(Callable<?> action) {
        return WaitResult.of(() -> {
            try {
                action.call();
                return null;
            }
            catch (Exception e) {
                return e;
            }
        }).dontIgnoreException().expectingNotNull();
    }
}

