/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.async.lang;

import ch.powerunit.extensions.async.lang.WaitResultBuilder3;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;

public interface WaitResultBuilder2<T> {
    public WaitResultBuilder3<T> expecting(Predicate<T> var1);

    default public WaitResultBuilder3<T> expectingEqualsTo(T other) {
        return this.expecting(Predicate.isEqual(other));
    }

    default public WaitResultBuilder3<T> expectingNotNull() {
        return this.expecting(Objects::nonNull);
    }

    default public WaitResultBuilder3<T> expectingNot(Predicate<T> notAcceptingClause) {
        return this.expecting(Objects.requireNonNull(notAcceptingClause, "notAcceptingClause can't be null").negate());
    }

    default public WaitResultBuilder3<T> expectingAnyOf(Predicate<T> acceptingClause1, Predicate<T> ... next) {
        Predicate<T> base = Objects.requireNonNull(acceptingClause1, "acceptingClause1 can't be null");
        return this.expecting(Arrays.stream(next).reduce(base, Predicate::or));
    }

    default public WaitResultBuilder3<T> expectingAllOf(Predicate<T> acceptingClause1, Predicate<T> ... next) {
        Predicate<T> base = Objects.requireNonNull(acceptingClause1, "acceptingClause1 can't be null");
        return this.expecting(Arrays.stream(next).reduce(base, Predicate::and));
    }
}

