/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.async.impl;

import ch.powerunit.extensions.async.impl.WaitResultImpl;
import ch.powerunit.extensions.async.lang.RetryPolicy;
import java.util.Optional;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class RetryImpl<T> {
    private static final System.Logger LOGGER = System.getLogger(RetryImpl.class.getName());
    private final WaitResultImpl<T> on;
    private int retryCount;
    private Optional<T> result;
    private Exception previousException;

    public RetryImpl(WaitResultImpl<T> on) {
        this.on = on;
        this.retryCount = 0;
    }

    public boolean next() {
        RetryPolicy retryClause = this.on.getRetryClause();
        if (this.retryCount >= retryClause.getCount()) {
            return false;
        }
        LOGGER.log(System.Logger.Level.INFO, "retry {0} using {1} on {2}", this.retryCount, retryClause, this.on);
        if (this.retryCount > 0) {
            retryClause.sleepBetweenRetry(this.retryCount);
        }
        ++this.retryCount;
        this.previousException = null;
        try {
            this.result = this.on.call();
        }
        catch (Exception e) {
            this.result = Optional.empty();
            this.previousException = e;
        }
        return true;
    }

    public Optional<T> getResult() {
        return this.result;
    }

    public Exception getPreviousException() {
        return this.previousException;
    }
}

