/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.async.impl;

import ch.powerunit.extensions.async.impl.ExceptionHandler;
import ch.powerunit.extensions.async.impl.RetryImpl;
import ch.powerunit.extensions.async.lang.RetryPolicy;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Supplier;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class WaitResultImpl<T>
implements Supplier<Optional<T>>,
Callable<Optional<T>> {
    private final Callable<Optional<T>> action;
    private final ExceptionHandler exceptionHandler;
    private final RetryPolicy retryClause;

    public WaitResultImpl(Callable<Optional<T>> action, boolean alsoDontFailWhenNoResultAndException, RetryPolicy retryClause) {
        this.action = Objects.requireNonNull(action, "action can't be null");
        this.exceptionHandler = new ExceptionHandler(true, alsoDontFailWhenNoResultAndException);
        this.retryClause = Objects.requireNonNull(retryClause, "retryClause can't be null");
    }

    public WaitResultImpl(Callable<Optional<T>> action, RetryPolicy retryClause) {
        this.action = Objects.requireNonNull(action, "action can't be null");
        this.exceptionHandler = new ExceptionHandler(false, false);
        this.retryClause = Objects.requireNonNull(retryClause, "retryClause can't be null");
    }

    @Override
    public Optional<T> get() {
        RetryImpl retry = new RetryImpl(this);
        while (retry.next()) {
            this.exceptionHandler.handleException(retry.getPreviousException());
            Optional result = retry.getResult();
            if (!result.isPresent()) continue;
            return result;
        }
        this.exceptionHandler.handleFinalException(retry.getPreviousException());
        return Optional.empty();
    }

    public RetryPolicy getRetryClause() {
        return this.retryClause;
    }

    @Override
    public Optional<T> call() throws Exception {
        return this.action.call();
    }

    public String toString() {
        return "WaitResultImpl [action=" + this.action + ", exceptionHandler=" + this.exceptionHandler + "]";
    }
}

