/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.async.lang;

import ch.powerunit.extensions.async.lang.RetryPolicy;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.IntToLongFunction;
import java.util.function.Supplier;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class RetryPolicies {
    private static final System.Logger LOGGER = System.getLogger(RetryPolicies.class.getName());
    public static final RetryPolicy RETRY_ONLY_ONCE = RetryPolicies.of(1, 1L);

    private RetryPolicies() {
    }

    public static RetryPolicy of(int count, long ms) {
        return RetryPolicies.of(count, RetryPolicies.addToString(l -> ms, () -> String.format("Constant wait time of %s ms", ms)));
    }

    public static RetryPolicy of(int count, long value, TimeUnit unit) {
        return RetryPolicies.of(count, Objects.requireNonNull(unit, "unit can't be null").toMillis(value));
    }

    public static RetryPolicy of(int count, Duration duration) {
        return RetryPolicies.of(count, Objects.requireNonNull(duration, "duration can't be null").toMillis());
    }

    public static RetryPolicy of(final int count, final IntToLongFunction retryToWaitTime) {
        return new RetryPolicy(){

            @Override
            public void sleepBetweenRetry(int retry) {
                RetryPolicies.sleepBetweenRetry(retryToWaitTime.applyAsLong(retry));
            }

            @Override
            public int getCount() {
                return count;
            }

            public String toString() {
                return String.format("total count = %s, with sleep method = %s", count, retryToWaitTime);
            }
        };
    }

    public static RetryPolicy ofIncremental(int count, long ms) {
        return RetryPolicies.of(count, RetryPolicies.addToString(retry -> (long)retry * ms, () -> String.format("Incremental retry based on %s ms", ms)));
    }

    public static RetryPolicy ofIncremental(int count, Duration duration) {
        return RetryPolicies.ofIncremental(count, Objects.requireNonNull(duration, "duration can't be null").toMillis());
    }

    private static IntToLongFunction addToString(final IntToLongFunction target, final Supplier<String> toString) {
        return new IntToLongFunction(){

            @Override
            public long applyAsLong(int value) {
                return target.applyAsLong(value);
            }

            public String toString() {
                return (String)toString.get();
            }
        };
    }

    private static void sleepBetweenRetry(long ms) {
        try {
            LOGGER.log(System.Logger.Level.DEBUG, "Waiting {1} ms", ms);
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

