/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.async.lang;

import ch.powerunit.extensions.async.impl.WaitResultImpl;
import ch.powerunit.extensions.async.lang.WaitResultBuilder1;
import ch.powerunit.extensions.async.lang.WaitResultBuilder2;
import ch.powerunit.extensions.async.lang.WaitResultBuilder3;
import ch.powerunit.extensions.async.lang.WaitResultBuilder5;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import java.util.function.Supplier;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class WaitResult {
    private WaitResult() {
    }

    public static <T> WaitResultBuilder1<T> of(Callable<T> action) {
        return WaitResult.of(action, null);
    }

    public static <T> WaitResultBuilder1<T> of(final Callable<T> action, final Runnable actionOnFinish) {
        Objects.requireNonNull(action, "action can't be null");
        return new WaitResultBuilder1<T>(){

            @Override
            public WaitResultBuilder3<T> expecting(Predicate<T> acceptingClause) {
                return retry -> ((WaitResultBuilder5)new WaitResultImpl(WaitResult.asFilteredCallable(action, acceptingClause), retry)::get).onFinish(actionOnFinish);
            }

            @Override
            public WaitResultBuilder2<T> ignoreException(boolean alsoDontFailWhenNoResultAndException) {
                return predicate -> retry -> ((WaitResultBuilder5)new WaitResultImpl(WaitResult.asFilteredCallable(action, predicate), alsoDontFailWhenNoResultAndException, retry)::get).onFinish(actionOnFinish);
            }
        };
    }

    private static <T> Callable<Optional<T>> asFilteredCallable(Callable<T> action, Predicate<T> acceptingClause) {
        Objects.requireNonNull(action, "action can't be null");
        Objects.requireNonNull(acceptingClause, "acceptingClause can't be null");
        return WaitResult.callableWithToString(() -> Optional.ofNullable(action.call()).filter(acceptingClause), () -> String.format("Action = %s, AcceptingClause = %s", action, acceptingClause));
    }

    public static <T> WaitResultBuilder1<T> ofSupplier(Supplier<T> supplier) {
        Objects.requireNonNull(supplier, "supplier can't be null");
        return WaitResult.of(WaitResult.callableWithToString(supplier::get, () -> supplier.toString()));
    }

    public static WaitResultBuilder3<Boolean> ofRunnable(Runnable action) {
        Objects.requireNonNull(action, "action can't be null");
        return WaitResult.of(WaitResult.callableWithToString(Executors.callable(action, true), () -> action.toString())).ignoreException(true).expecting(WaitResult.predicateWithToString(b -> b, () -> "Expecting true"));
    }

    public static <T> WaitResultBuilder2<T> on(T mutableObject) {
        return WaitResult.of(WaitResult.callableWithToString(() -> mutableObject, () -> String.format("on object %s", mutableObject)));
    }

    public static WaitResultBuilder3<Boolean> onCondition(Supplier<Boolean> conditionSupplier) {
        Objects.requireNonNull(conditionSupplier, "conditionSupplier can't be null");
        return WaitResult.of(WaitResult.callableWithToString(conditionSupplier::get, () -> conditionSupplier.toString())).expecting(WaitResult.predicateWithToString(b -> b, () -> "Expecting true"));
    }

    public static WaitResultBuilder3<Exception> forException(Callable<?> action) {
        Objects.requireNonNull(action, "action can't be null");
        return WaitResult.of(WaitResult.asCallableForException(action, e -> e)).dontIgnoreException().expectingNotNull();
    }

    public static <T extends Exception> WaitResultBuilder1<T> forException(Callable<?> action, Class<T> targetException) {
        Objects.requireNonNull(action, "action can't be null");
        Objects.requireNonNull(targetException, "targetException can't be null");
        return WaitResult.of(WaitResult.asCallableForException(action, e -> Optional.of(e).filter(c -> targetException.isAssignableFrom(c.getClass())).orElseThrow(() -> e)));
    }

    private static <T extends Exception> Callable<T> asCallableForException(Callable<?> action, ExceptionMapper<T> exceptionHandler) {
        return WaitResult.callableWithToString(() -> {
            try {
                action.call();
                return null;
            }
            catch (Exception e) {
                return exceptionHandler.handleException(e);
            }
        }, () -> action.toString());
    }

    public static <T> Callable<T> callableWithToString(final Callable<T> callable, final Supplier<String> toString) {
        Objects.requireNonNull(callable, "callable can't be null");
        Objects.requireNonNull(toString, "toString can't be null");
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                return callable.call();
            }

            public String toString() {
                return (String)toString.get();
            }
        };
    }

    public static <T> Predicate<T> predicateWithToString(final Predicate<T> predicate, final Supplier<String> toString) {
        Objects.requireNonNull(predicate, "predicate can't be null");
        Objects.requireNonNull(toString, "toString can't be null");
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return predicate.test(t);
            }

            public String toString() {
                return (String)toString.get();
            }
        };
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static interface ExceptionMapper<T extends Exception> {
        public T handleException(Exception var1) throws Exception;
    }
}

