/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.async.impl;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ExceptionHandler {
    private final boolean ignoreException;
    private final boolean alsoDontThrowLastExceptionWhenNoResult;

    public ExceptionHandler(boolean ignoreException, boolean alsoDontThrowLastExceptionWhenNoResult) {
        this.ignoreException = ignoreException;
        this.alsoDontThrowLastExceptionWhenNoResult = alsoDontThrowLastExceptionWhenNoResult;
    }

    public void handleException(Exception e) {
        if (e != null && !this.ignoreException) {
            throw new AssertionError("Unable to obtains the result during one try, because of " + e.getMessage() + " ; Original error class is " + e.getClass(), e);
        }
    }

    public void handleFinalException(Exception e) {
        if (e != null && !this.alsoDontThrowLastExceptionWhenNoResult) {
            throw new AssertionError("Unable to obtains the result and finish in error, because of " + e.getMessage() + " ; Original error class is " + e.getClass(), e);
        }
    }

    public String toString() {
        return "ExceptionHandler [ignoreException=" + this.ignoreException + ", alsoDontThrowLastExceptionWhenNoResult=" + this.alsoDontThrowLastExceptionWhenNoResult + "]";
    }
}

