/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.async.impl;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class FilePool
implements Callable<Collection<WatchEvent<Path>>> {
    private static final Predicate<WatchEvent<?>> IGNORE_OVERFLOW = e -> !Objects.equals(e.kind(), StandardWatchEventKinds.OVERFLOW);
    private static final Function<WatchEvent<?>, WatchEvent<Path>> COERCE_TO_PATH = e -> e;
    private final Path directory;
    private final WatchEvent.Kind<?>[] events;
    private WatchService watcher;
    private WatchKey key;

    public FilePool(Path directory, WatchEvent.Kind<?> ... events) {
        this.directory = directory;
        this.events = events;
    }

    @Override
    public Collection<WatchEvent<Path>> call() throws Exception {
        this.initIfNeeded();
        try {
            Collection collection = this.key.pollEvents().stream().filter(IGNORE_OVERFLOW).map(COERCE_TO_PATH).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
            return collection;
        }
        finally {
            this.key.reset();
        }
    }

    public void close() {
        Optional.ofNullable(this.watcher).ifPresent(FilePool::safeCloseWatchService);
    }

    public String toString() {
        return "FilePool [directory=" + this.directory + ", events=" + Arrays.toString(this.events) + "]";
    }

    private void initIfNeeded() throws IOException {
        if (this.watcher == null) {
            this.watcher = this.directory.getFileSystem().newWatchService();
            this.key = this.directory.register(this.watcher, this.events);
        }
    }

    private static void safeCloseWatchService(WatchService watcher) {
        try {
            watcher.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

